/*
* Copyright(C) 2003  CERTEX
*
*    ,     .
* 
*        ,
* ,    ,
*     ,
* ,      
*     
*      .
*
*
* FileVersion  : 1.1.211.227
* PrivateBuild : 1.43
* Date modify  : 09.07.03
* FileDescription : CERTEX CryptoAPI 
*
*/

#ifndef __STRLIB_H__
#define __STRLIB_H__


// BUILD_DLL_STRLIB       DLL
#include "crtstructure.h"

#define CMS_DATA                0 // 
#define CMS_SIGN_DATA           1 // 
#define CMS_ENVP_DATA           2 //     ( )
#define CMS_DIGS_DATA           3 // 
#define CMS_ENCR_DATA           4 //   
#define CMS_AUTH_DATA           5 // 
#define LDAP_DATA               7 //  OFF-LINE

#define ONLY_ONE_CA     1
#define MORE_ONE_CA     0


//  ...
#ifdef _WIN32

#ifndef _INC_WINDOWS
#include <windows.h>
#endif 
#include <wincrypt.h>

#ifdef BUILD_DLL_STRLIB
//    
#define _WIN_DLL extern "C" __declspec(dllexport)

#else
//    
#define _WIN_DLL extern "C" __declspec(dllimport)

#endif

//#define WINAPI __stdcall  // compile option -> /Gz

//  ...
#else

#include "wdefs.h"
#define _WIN_DLL extern "C"

#endif

typedef unsigned long ulong32;

//   ...


typedef void (*t_callback)(int,int,void *);

#define CRT_STORE_PROV_LDAP     0
#define CRT_STORE_PROV_MEMORY   1
#define CRT_STORE_PROV_SYSTEM   2
#define CRT_STORE_PROV_FILE     3



//typedef unsigned long hPKICONTEXT;
//typedef unsigned long hENROLLCONTEXT;
//typedef unsigned long hCERTCONTEXT;
//typedef unsigned long hCRLCONTEXT;
//typedef unsigned long hCRYPTMSG;
//typedef unsigned long hAUTHMSG;
//typedef unsigned long hCERTCHAINCONTEXT;
//typedef unsigned long hCERTCOLLECTION;
//
//typedef struct _CERT_CRL_CHAIN {
//  int             certCount;
//  hCERTCONTEXT    hCertContext;
//  int             crlCount;
//  hCRLCONTEXT     hCRLContext;
//  int             crtcrlCount;
//  hCERTCONTEXT    hCertCRLContext;
//  unsigned long   Flags;
//} CERT_CRL_CHAIN, *pCERT_CRL_CHAIN;
//
//
//
//typedef struct _CERT_COLLECTION {
//  int             certCount;
//  hCERTSTORE      hStore;
//  hCERTSTORE      hMY;
//  hCERTCONTEXT    hContext;
//  unsigned long   Flags;
//} CERT_COLLECTION, *pCERT_COLLECTION;


//**************************************************************

_WIN_DLL int __initSSL(char *lib_path);

_WIN_DLL int __chkSSL(void);

_WIN_DLL void __finiSSL(void);



_WIN_DLL char * ErrorString(const int err);

/*
*   CertOpenStore       -   
*
*       - StoreProvider -     0-SOCKET
*                                                                    1-DDE
*                                                                    2-SYSTEM
*                                                                    3-HARDDISK
*                         hProv   -    (   CSPOpenContext)
*                         dwFlags - 1 - ONLY_ONE_CA, 0 - MORE_ONE_CA.
*                         bFlags  - 
*                         pvPara  - 
*
*      - phStore -  ()  .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtOpenStore
                       (DWORD StoreProvider,
                        HCRYPTPROV hProv,
                        unsigned long dwFlags,
                        bool  bFlag,
                        const void *pvParam,
                        hCERTSTORE *phStore);


/*
*   CertSetStoreProperty-   
*
*       - hStore  -  ()  .
*                         Flags   - ONLY_ONE_CA  MORE_ONE_CA
*                         host    -  ( "192.168.7.100"  "C:\\Store\\Local")
*                         port    -  ( 62102  "LOCAL")
*                         name    -  ( NULL)
*                         pass    -  ( NULL)
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtSetStoreProperty
                               (const hCERTSTORE hStore,
                                const unsigned long Flags,
                                const char *host,
                                const char *port,
                                const char *name,
                                const char *pass);


/*
*   CrtSetStorePropertyExt  -   
*
*       - hStore  -  ()  .
*                         Flags   - ONLY_ONE_CA  MORE_ONE_CA
*                         DName   -     ( )
*                                   [L] -  "
*                                   [M] -   "
*                                   [A] -   "
*                                   [R] -    "
*                                   [I] -  "
*                                   [T] -  trust-"
*                                   [Z] -   "
*                         host    -  ( "192.168.7.100"  "C:\\Store\\Local")
*                         port    -  ( 62102  "LOCAL")
*                         timeOut -   
*                         name    -  ( NULL)
*                         pass    -  ( NULL)
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtSetStorePropertyExt
                                 (const hCERTSTORE hStore,
                                  const unsigned long Flags,
                                  const char *DName,
                                  const char *host,
                                  const char *port,
                                  const int timeOut,
                                  const char *name,
                                  const char *pass);


_WIN_DLL int CrtSetStorePKCS11(const hCERTSTORE hStore,
                               HCRYPTPROV hProv);

/*
*   CrtSetURL          -  URL
*
*       - hStore  -  ()  .
*                         URL     - <>://[< >[:<>[:mech[:FQDN]]]@]<>[:<>][/dn[?[attributes][?[scope]]]
*                                    mech       = NTLM,DIGEST-MD5,...
*                                    FQDN       = (Fully Qualified Domain Name )
*                                    dn         =  distinguishedName
*                                    scope      = "base" / "one" / "sub"
*                                    attributes =  attrdesc *("," attrdesc) (temporarily not supported)*
*                         sasl_path -    SASL ( NULL)
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtSetURL
                      (const hCERTSTORE hStore,
                      const char *URL,
                      const char *sasl_path);


/*
*   CrtConnectToStore   -    
*
*       - hStore  -  ()  .
*                         Flags   - ONLY_ONE_CA  MORE_ONE_CA
*                         timeOut -   
*                         URL     - <>://[< >[:<>[:mech[:FQDN]]]@]<>[:<>][/dn[?[attributes][?[scope]]]
*                                    mech       = NTLM,DIGEST-MD5,...
*                                    FQDN       = (Fully Qualified Domain Name )
*                                    dn         =  distinguishedName
*                                    scope      = "base" / "one" / "sub"
*                                    attributes =  attrdesc *("," attrdesc) (temporarily not supported)*
*                         sasl_path -    SASL ( NULL)
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtConnectToStore
                              (const hCERTSTORE hStore,
                              const unsigned long Flags,
                              const int timeOut,
                              const char *URL,
                              const char *sasl_path);


/*
*   CrtSetProxy         -  PROXY     
*
*       - hStore        -  ()  .
*                         proxy_type    - 
*                         proxy_host    - 
*                         proxy_port    - 
*                         proxy_name    -
*                         proxy_pass    -
*                         proxy_exclude - 
*                         proxy_dns_flag-
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtSetProxy
                       (const hCERTSTORE hStore,
                        const int proxy_type,
                        const char *proxy_host,
                        const char *proxy_port,
                        const char *proxy_name,
                        const char *proxy_pass,
                        const char *proxy_exclude,
                        const int proxy_dns_flag);

/*
*   CrtSetSSL           -  SSL     
*
*       - hStore       -  ()  .
*                         file_pkey    - 
*                         file_cert    - 
*                         file_ca_cert - 
*                         path_ca      -
*                         cert_verify  -
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtSetSSL
                     (const hCERTSTORE hStore,
                      const char *file_pkey,
                      const char *file_cert,
                      const char *file_ca_cert,
                      const char *path_ca,
                      const int  cert_verify);


/*
*   CrtSetSSLKey        -  SSL     
*
*       - hStore      -  ()  .
*                         key_type    - 
*                         key_size    - 
*                         key         - 
*                         cert_size   -
*                         cert        -
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtSetSSLKey
                         (const hCERTSTORE hStore,
                          int key_type,
                          unsigned long key_size,
                          unsigned char *key,
                          unsigned long cert_size,
                          unsigned char *cert);


/*
*   IsLDAPexist         -   LDAP 
*
*       - hStore    -  ()  .
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int IsLDAPexist(const hCERTSTORE hStore);



/*
*   CertCloseStore      -   
*
*       - hStore -  ()  .
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtCloseStore(hCERTSTORE *phStore);



/*
*   SetLDAPver          -     (    ). 
*
*       - hStore  -  ()  .
*                         ver     -   ( 3)
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL void SetLDAPver(hCERTSTORE hStore, int ver);


/*
*   CreateUserStore     -  .    (ROOT, COMMON, LOCAL  ..).
*
*       - hStore    -  ()  .
*                         ownerName -     DN
*                                     (   ROOT,  COMMON   port)
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CreateUserStore
                         (hCERTSTORE hStore,
                          const char *ownerName);



/*
*   GetOwnerName        -    
*
*       - hStore    -  ()  .
*                         DName
*
*      - ownerName -     DN.
*                                        .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetOwnerName
                       (hCERTSTORE hStore,
                        const char *DName,
                        char *ownerName);


/*
*   AddOwnerName        -    
*
*       - hStore    -  ()  .
*                         DName
*                         ownerName -     DN.
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddOwnerName
                        (hCERTSTORE hStore,
                         const char *DName,
                         const char *ownerName);

/*
*   GetModifyTime       -     
*
*       - hStore    -  ()  ,
*                         DName
*
*      - modifyTime -    "20020903000000Z".
*                                        .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetModifyTime
                          (hCERTSTORE hStore,
                           const char *DName,
                           char *modifyTime);


//**************************************************************


/*
*   AddTrustNode        -       .  
*                          ,  .
*
*       - hStore   -  ()  
*                         node     -   
*                         GName    -    
*                         DName    -   
*                         hostLDAP -  LDAP   
*                         portLDAP -  LDAP 
*                         hostCRL  -      
*                         portCRL  -     
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddTrustNode
                        (hCERTSTORE hStore,
                         const char *node,
                         const char *GName,
                         const char *DName,
                         const char *hostLDAP,
                         const char *portLDAP,
                         const char *hostCRL,
                         const char *portCRL);


/*
*   AddCertificate      -    .    ,
*                          .
*
*       - hStore   -  ()  
*                         certBody - 
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCertificate
                         (hCERTSTORE hStore,
                          const unsigned char *certBody,
                          const unsigned long bodySize);


/*
*   AddCertificateExist -     .
*
*       - hStore   -  ()  
*                         certBody - 
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCertificateExist
                               (hCERTSTORE hStore,
                                const unsigned char *certBody,
                                const unsigned long bodySize);

/*
*   AddCertificateTemp  -     .    ,
*                          .
*
*       - hStore   -  ()  
*                         DName    -     DN
*                         certBody -  
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCertificateTemp(hCERTSTORE hStore,
                                const char *DName,
                                const unsigned char *certBody,
                                const unsigned long bodySize);


/*
*   AddCACertificate    -      .
*                              createUserStore.
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         certBody - 
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCACertificate
                           (hCERTSTORE hStore,
                            const char *DName,
                            const unsigned char *certBody,
                            const unsigned long bodySize);


/*
*   AddCAOldCertificate -       .
*                         ,     .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         certBody - 
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCAOldCertificate
                             (hCERTSTORE hStore,
                              const char *DName,
                              const unsigned char *certBody,
                              const unsigned long bodySize);


/*
*   AddCANewOld         -   ,       .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         certBody - 
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCANewOld
                     (hCERTSTORE hStore,
                      const char *DName,
                      const unsigned char *certBody,
                      const unsigned long bodySize);


/*
*   AddCAOldNew         -    ,    
*                           .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         certBody - 
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCAOldNew
                     (hCERTSTORE hStore,
                      const char *DName,
                      const unsigned char *certBody,
                      const unsigned long bodySize);



/*
*   AddCRL              -     R.
*                         ,     .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         crlBody -   
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddCRL
                 (hCERTSTORE hStore,
                  const char *DName,
                  const unsigned char *crlBody,
                  const unsigned long bodySize);

/*
*   AddDeltaCRL         -      R.
*                         ,     .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         crlBody -   
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddDeltaCRL(hCERTSTORE hStore,
                        const char *DName,
                        const unsigned char *crlBody,
                        const unsigned long bodySize);


/*
*   AddUserCRL          -     .    !
*                         ,     .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         crlBody -   
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddUserCRL
                 (hCERTSTORE hStore,
                  const char *DName,
                  const unsigned char *crlBody,
                  const unsigned long bodySize);




/*
*   AddUserRequest      -  CMC   .    ,
*                          .
*
*       - hStore    -  ()  
*                         type      -   0, 1, 2  3
*                         DName     -     DN
*                         transID   -  
*                         reqBody   - 
*                         bodySize  - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AddUserRequest
                          (hCERTSTORE hStore,
                           const int type,
                           const char *DName,
                           const char *transID,
                           const unsigned char *reqBody,
                           const unsigned long bodySize);

/*
*   SaveTimeStamp      -    .    ,
*                          .
*
*       - hStore    -  ()  
*                         DName     -     DN
*                         reqBody   - 
*                         bodySize  - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SaveTimeStamp
                          (hCERTSTORE hStore,
                           const char *DName,
                           const unsigned char *reqBody,
                           const unsigned long bodySize);

//***************************************************************

/*
*   DelRevokedNode      -     .
*
*       - hStore   -  ()  
*                         groupName -      DN ("C=KZ")
*                         crlBody - 
*                         bodySize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DelRevokedNode
                       (hCERTSTORE hStore,
                        const char *groupName,
                        const unsigned char *crlBody,
                        const unsigned long bodySize);




/*
*   DelInvalidNode      -     .
*
*       - hStore     -  ()  
*                         groupName  -      DN ("C=KZ")
*                         dataValid  -  
*                         deltaValid -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DelInvalidNode
                      (hCERTSTORE hStore,
                       const char *groupName,
                       const char *dataValid,
                       const unsigned int deltaValid);


/*
*   DelNode             -    DN  .
*
*       - hStore   -  ()  
*                         DName -     DN
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DelNode
                    (hCERTSTORE hStore,
                     const char *DName);




/*
*   DelTrustNode        -      .
*
*       - hStore   -  ()  
*                         node      -   
*                         GName     -    
*                         DName     -   
*                         hostLDAP  -  LDAP   
*                         portLDAP  -  LDAP 
*                         hostCRL   -     
*                         portCRL   -   
*
*      - .
*
*              - 0    ,   myerror.h
*/
 _WIN_DLL int DelTrustNode
                          (hCERTSTORE hStore,
                           const char *node,
                           const char *GName,
                           const char *DName,
                           const char *hostLDAP,
                           const char *portLDAP,
                           const char *hostCRL,
                           const char *portCRL);


/*
*   DelCertificate      -    .   ,
*                           .
*
*       - hStore   -  ()  
*                         DName -     . 
*                         isCA     - 
*                         certBody -  
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DelCertificate
                         (hCERTSTORE hStore,
                          const char *DName,
                          const bool isCA,
                          const unsigned char  *certBody,
                          const unsigned long  bodySize);


/*
*   DelCertificateTemp  -     .   ,
*                           .
*
*       - hStore   -  ()  
*                         DName -     .
*                         tempBody -  
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DelCertificateTemp
                               (hCERTSTORE hStore,
                                const char *DName,
                                const unsigned char  *tempBody,
                                const unsigned long  bodySize);


/*
*   DelCertificateRequest  -     .   ,
*                           .
*
*       - hStore   -  ()  
*                         type     -
*                         DName    -     . 
*                         reqBody  -  
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DelCertificateRequest
                                 (hCERTSTORE hStore,
                                  const int type,
                                  const char *DName,
                                  const unsigned char  *reqBody,
                                  const unsigned long  bodySize);

/*
*   RevCertificate      -  .   ,
*                           .
*
*       - hStore   -  ()  
*                         revDate -     "YYYYMMDDHHMMSSZ"
*                         revReason -   (. CRL.H)
*                         certBody -  
*                         bodySize - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int RevCertificate
                         (hCERTSTORE hStore,
                          const char *revDate,
                          const int revReason,
                          const unsigned char  *certBody,
                          const unsigned long  bodySize);



/*
*   KillZombi -   CERTEX OFF-LINE.   .
*/
_WIN_DLL int KillZombi
                   (hCERTSTORE *hStore,
                    const char *DName);


//***************************************************************


/*
*   GetCACertificateKey  -   .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         keyOID -  ,
*                         isValid
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCACertificateKey
                           (hCERTSTORE hStore,
                            const char *DName,
                            const char *keyOID,
                            const bool isValid,
                            unsigned char *certBody,
                            unsigned long *bodySize);


/*
*   GetCACertificateNum  -   .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         serNum -   .
*                         len    -   .
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCACertificateNum
                           (hCERTSTORE hStore,
                            const char *DName,
                            const unsigned char *serNum,
                            const long len,
                            unsigned char *certBody,
                            unsigned long *bodySize);


/*
*   GetCAOldCertificate -    .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         serNum -   .
*                         len    -   .
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCAOldCertificate
                             (hCERTSTORE hStore,
                              const char *DName,
                              const unsigned char *serNum,
                              const long len,
                              unsigned char *certBody,
                              unsigned long *bodySize);


/*
*   GetCANewOld         -    ,    .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         serNum -   .
*                         len    -   .
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCANewOld
                     (hCERTSTORE hStore,
                      const char *DName,
                      const unsigned char *serNum,
                      const long len,
                      unsigned char *certBody,
                      unsigned long *bodySize);


/*
*   GetCAOldNew         -    ,    .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         serNum -   .
*                         len    -   .
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCAOldNew
                         (hCERTSTORE hStore,
                          const char *DName,
                          const unsigned char *serNum,
                          const long len,
                          unsigned char *certBody,
                          unsigned long *bodySize);


/*
*   GetCurrentCRL       -  .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*
*      - crlBody -   .
*                                      .
*                                     NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCurrentCRL
                          (hCERTSTORE hStore,
                           const char *DName,
                           unsigned char *crlBody,
                           unsigned long *bodySize);

/*
*   GetCurrentCRLNumber -   .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*
*      - num - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCurrentCRLNumber(hCERTSTORE hStore,
                                 const char *DName,
                                 ulong32 *num);

/*
*   GetCRLExt           -  .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*
*      - crlBody -     .
*                                     .
*                                     NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLExt
                          (hCERTSTORE hStore,
                           const char *DName,
                           unsigned char **crlBody,
                           unsigned long *bodySize);


/*
*   GetCRLbyIndex       -  .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         index - 
*
*      - crlBody -     .
*                                     .
*                                     NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLbyIndex(hCERTSTORE hStore,
                          const char *DName,
                          const int index,
                          unsigned char **crlBody,
                          unsigned long *bodySize);

/*
*   GetDeltaCRL         -   .
*
*       - hStore   -  ()  
*                         DName -     .  Root  "".
*                         index - 
*
*      - crlBody -     .
*                                     .
*                                     NULL,    .
*                         bodySize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetDeltaCRL(hCERTSTORE hStore,
                        const char *DName,
                        const int index,
                        unsigned char **crlBody,
                        unsigned long *bodySize);


/*
*   GetMYCertificate    -    .
*
*       - hStore   -  ()  
*                         DName    -     DN.
*                         keySpec  - AT_KEYEXCHANGE  AT_SIGNATURE.
*                         isCA     -
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetMYCertificate
                              (hCERTSTORE hStore,
                               const char *DName,
                               const unsigned long keySpec,
                               const bool isCA,
                               unsigned char *certBody,
                               unsigned long *bodySize);

/*
*   GetNumberCertificate-      .
*
*       - hStore   -  ()  
*                         DName  -     DN.
*                         serNum -   .
*                         len    -   .
*                         isRevoked -     (true)
*                                       (false).
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetNumberCertificate
                                 (hCERTSTORE hStore,
                                  const char *DName,
                                  const unsigned char *serNum,
                                  const long len,
                                  const bool isRevoked,
                                  unsigned char *certBody,
                                  unsigned long *bodySize);

/*
*   GetNameCertificate  -     .
*
*       - hStore   -  ()  
*                         DName  -     DN.
*                         keyOID -  .
*                         isValid   -     (true)
*                                       (false)
*                         isRevoked -     (true)
*                                       (false).
*
*      - certBody - .
*                                       .
*                                      NULL,    .
*                         bodySize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetNameCertificate
                              (hCERTSTORE hStore,
                               const char *DName,
                               const char *keyOID,
                               const bool isValid,
                               const bool isRevoked,
                               unsigned char *certBody,
                               unsigned long *bodySize);

/*
*   GetCertificateTemp  -      .
*
*       - hStore  -  ()  
*                         DName   -     DN.
*                         keyOID  -  .
*
*      - tempBody - .
*                                       .
*                                      NULL,    .
*                         bodySize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertificateTemp(hCERTSTORE hStore,
                                const char *DName,
                                const char *keyOID,
                                unsigned char *tempBody,
                                unsigned long *bodySize);


/*
*   GetTemplates        -      .
*
*       - hStore  -  ()  
*                         DName   -     DN.
*
*      - tempCount -   
*                         tempBody -  
*                                       .
*                                      NULL,    .
*                         bodySize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetTemplates(hCERTSTORE hStore,
                         const char *DName,
                         int *tempCount,
                         unsigned char **tempBody,
                         unsigned long *bodySize);

/*
*   GetGroupCertificate -      .
*
*       - hStore    -  ()  
*                         groupName -     DN.( "C=KZ; O=GAMMA;")
*                         Filter    -
*                         keyOID    -   0
*                         dataValid -   
*                         isValid   -     (true)
*                                       (false)
*                         isRevoked -     (true)
*                                       (false).
*
*      - certCount -   
*                         certBody  -  .
*                                        .
*                                       NULL,    .
*                         bodySize -    .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetGroupCertificate
                                 (hCERTSTORE hStore,
                                  const char *groupName,
                                  unsigned char *Filter,
                                  const char *keyOID,
                                  const char *dataValid,
                                  const bool isValid,
                                  const bool isRevoked,
                                  int *certCount,
                                  unsigned char **certBody,
                                  unsigned long *bodySize);


/*
*   StartGroupCertificate -          .
*
*       - hStore    -  ()  
*                         groupName -     DN.( "C=KZ; O=GAMMA;")
*                         Filter    -
*                         isRevoked -     (true)
*                                       (false).
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int StartGroupCertificate
                                 (hCERTSTORE hStore,
                                  const char *groupName,
                                  unsigned char *Filter,
                                  const bool isRevoked);


/*
*   NextGroupCertificate -      .
*
*       - hStore    -  ()  
*                         keyOID,   -   0
*                         dataValid -   
*                         isValid   -     (true)
*                                       (false)
*                         isRevoked -     (true)
*                                       (false).
*
*      - certCount -   
*                         certBody  -  .
*                                        .
*                                       NULL,    .
*                         bodySize -    .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int NextGroupCertificate
                                 (hCERTSTORE hStore,
                                  const char *keyOID,
                                  const char *dataValid,
                                  const bool isValid,
                                  const bool isRevoked,
                                  int *certCount,
                                  unsigned char **certBody,
                                  unsigned long *bodySize);


/*
*   NextRevokedCertificate  -       .
*
*       - hStore    -  ()  
*                         keyOID    -   0
*                         dataRev   -    ()
*                         dataValid -   
*                         isValid   -     (true)
*                                       (false)
*
*      - certCount -   
*                         revDate   -   
*                                        .
*                         revReason -   
*                                        .
*                         certBody  -  .
*                                        .
*                                       NULL,    .
*                         bodySize -    .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int NextRevokedCertificate
                                  (hCERTSTORE hStore,
                                   const char *keyOID,
                                   const char *dataRev,
                                   const char *dataValid,
                                   const bool isValid,
                                   int *certCount,
                                   char **revDate,
                                   int *revReason,
                                   unsigned char **certBody,
                                   unsigned long *bodySize);



/*
*   GetGroupRevoke     -       .
*
*       - hStore    -  ()  
*                         groupName -   ( )   DN.( "C=KZ; O=GAMMA;")
*                         keyOID    -   NULL
*                         dataRev   -    ()
*                         dataValid -   
*                         isValid   -     (true)
*                                       (false)
*
*      - certCount -   
*                         revDate   -   
*                                        .
*                         revReason -   
*                                        .
*                         certBody  -  .
*                                        .
*                                       NULL,    .
*                         bodySize -    .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetGroupRevoke
                           (hCERTSTORE hStore,
                            const char *groupName,
                            const char *keyOID,
                            const char *dataValid,
                            const char *dataRev,
                            const bool isValid,
                            int *certCount,
                            char **revDate,
                            int *revReason,
                            unsigned char **certBody,
                            unsigned long *bodySize);



/*
*   GetGroupCA -   CA   .
*
*       - hStore   -  ()  
*                         groupName -     DN.( "C=KZ; O=GAMMA;")
*                         dataValid -   
*                         isValid   -     (true)
*                                       (false)
*
*      - certCount -   
*                         certBody  -  .
*                                        .
*                                       NULL,    .
*                         bodySize -    .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetGroupCA
                       (hCERTSTORE hStore,
                        const char *groupName,
                        const char *dataValid,
                        const bool isValid,
                        int *certCount,
                        unsigned char **certBody,
                        unsigned long *bodySize);


/*
*   GetTrustNode        -       .
*
*       - hStore    -  ()  
*                         node      -        (C=KZ)
*
*      - count     -    
*                         CName     -      
*                         DName     -    
*                         hostLDAP  -  LDAP   
*                         portLDAP  -  LDAP 
*                         hostCRL   -      
*                         portCRL   -     
*
*                            .
*                           NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetTrustNode
                        (hCERTSTORE hStore,
                         const char *node,
                         int *count,
                         char **CName,
                         char **DName,
                         char **hostLDAP,
                         char **portLDAP,
                         char **hostCRL,
                         char **portCRL);



/*
*   GetDName -   CA   .
*
*       - hStore    -  ()  
*                         groupName -   ( )   DN.( "C=KZ; O=GAMMA;")
*                         scope     - SCOPE_SUB_TREE
*                         offset    - start
*                         count     - max -  
*
*      - count   - -  
*                         DName   -  
*                         filter
*                         size
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetDName
                      (hCERTSTORE hStore,
                       char *groupName,
                       int offset,
                       int scope,
                       int *count,
                       char **DName,
                       unsigned char *filter,
                       long *size);


/*
*   GetUserRequest      -    .
*
*       - hStore    -  ()  
*                         type      -   0, 1, 2  3
*                         DName     -   (  )   DN
*                         transID   -  
*                         sendName  -      DN
*                         notBefore -    "  "
*                         notAfter  -    "  "
*
*      - reqCount  -   
*                         reqBody   -  .
*                                        .
*                                       NULL,    .
*                         bodySize  -   .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetUserRequest
                          (hCERTSTORE hStore,
                           const int type,
                           const char *DName,
                           const char *transID,
                           const char *sendName,
                           const char *notBefore,
                           const char *notAfter,
                           int *reqCount,
                           unsigned char **reqBody,
                           unsigned long *bodySize);

/*
*   GetTimeStamp        -   .
*
*       - hStore    -  ()  
*                         DName     -   (  )   DN
*                         reqTime   -  
*
*      - reqCount  -   
*                         reqBody   -  .
*                                        .
*                                       NULL,    .
*                         bodySize  -   .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetTimeStamp
                          (hCERTSTORE hStore,
                           const char *DName,
                           const char *reqTime,
                           int *reqCount,
                           unsigned char **reqBody,
                           unsigned long *bodySize);



/*
*   StartGroupRequest -          .
*
*       - hStore    -  ()  
*                         type      -   0, 1, 2  3 (. pkistructure.h)
*                                     CertificateRequest  =0
*                                     StatusOfCertificate =1
*                                     CertificateRevoke   =2
*                                     CertificateChange   =3
*                                     AnyUserRequest      =4 //   RA
*                                     AnyUserRevoke       =5 //   RA
*                                     StoreSecretKeys     =6 
*                                     LDAPRequest         =7
*                                     CertificatePattern  =8 

*                         groupName -     DN.( "C=KZ; O=GAMMA;")
*                         Filter    -
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int StartGroupRequest
                             (hCERTSTORE hStore,
                              const int type,
                              const char *groupName,
                              unsigned char *Filter);

/*
*   NextGroupRequest    -   .
*
*       - hStore    -  ()  
*                         type      -   0, 1, 2  3 (. pkistructure.h)
*
*      - reqCount  -   
*                         reqBody   -  .
*                                        .
*                                       NULL,    .
*                         bodySize  -   .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int NextGroupRequest
                            (hCERTSTORE hStore,
                             const int type,
                             int *reqCount,
                             unsigned char **reqBody,
                             unsigned long *bodySize);


/*
*   VerifyCertificates  -        L, 
*                              I.
*
*       - host    -   ldapi.
*                         baseDN  - ,    .
*                         timeout -   ,  1800 (    ).
*                         KeyOID  -      OID .
*                         ext_log -   
*                         lctx    -  
*
*      - node_count - -     .
*                         cert_del   - -     .
*                         cert_add   - -     .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int VerifyCertificates(hCERTSTORE hStore,
                               const char *host, 
                               const char *baseDN, 
                               int timeout, 
                               const char *KeyOID,
                               void (*ext_log)(int level, char op, void *ctx, const char *line,...),
                               void *lctx,
                               int *node_count, 
                               int *cert_del, 
                               int *cert_add);

/*
*   CRLVerifyTimeValidity -   .
*
*       - hStore   -  ()  
*                         pTime    -  
*                         crlBody -  
*                         bodySize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CRLVerifyTimeValidity
                                   (const hCERTSTORE hStore,
                                    const char *pTime,
                                    const unsigned char *crlBody,
                                    const unsigned long bodySize);


/*
*   CertVerifyTimeValidity -   .
*
*       - hStore   -  ()  
*                         pTime    -  
*                         certBody -  
*                         bodySize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyTimeValidity
                                    (const hCERTSTORE hStore,
                                     const char *pTime,
                                     const unsigned char *certBody,
                                     const unsigned long bodySize);


/*
*   GetCACertificateContext -  k     
*
*       - hStore -  ()  
*                         hCA    -  ()  
*                         hRoot  -  ()  
*                         hContext - k 
*
*      - hCAContext  - k  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCACertificateContext
                                    (const hCERTSTORE hStore,
                                     const hCERTSTORE hCA,
                                     const hCERTSTORE hRoot,
                                     const hCERTCONTEXT hContext,
                                     hCERTCONTEXT *hCAContext);


/*
*   GetCertificateContext      -  k 
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - hContext  - k 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertificateContext
                           (const hCERTSTORE hStore,
                            const unsigned char *certBody,
                            const unsigned long bodySize,
                            hCERTCONTEXT *phContext);


/*
*   ReleaseCertificateContext  -  k 
*
*       - hStore   -  ()  
*                         hContext  - k 
*      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ReleaseCertificateContext
                              (const hCERTSTORE hStore,
                               hCERTCONTEXT *phContext);


/*
*   GetCRLContext      -  k COC
*
*       - hStore   -  ()  
*                         crlBody  -  COC
*                         bodySize - 
*
*      - hContext  - k COC
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLContext
                           (const hCERTSTORE hStore,
                            const unsigned char *crlBody,
                            const unsigned long bodySize,
                            hCRLCONTEXT *phContext);


/*
*   ReleaseCRLContext  -  k 
*
*       - hStore   -  ()  
*                         hContext  - k COC
*      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ReleaseCRLContext
                              (const hCERTSTORE hStore,
                               hCRLCONTEXT *phContext);


/*
*   GetCRLnumber        -      CRL
*
*       - hStore   -  ()  
*                         crlBody  -  CRL
*                         bodySize - 
*      - number   - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLnumber
                          (const hCERTSTORE hStore,
                           const unsigned char *crlBody,
                           const unsigned long bodySize,
                           unsigned long *number);

/*
*   GetDeltaCRLnumber   -      CRL
*
*       - hStore   -  ()  
*                         crlBody  -  CRL
*                         bodySize - 
*      - number   - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetDeltaCRLnumber
                          (const hCERTSTORE hStore,
                           const unsigned char *crlBody,
                           const unsigned long bodySize,
                           unsigned long *number);


/*
*   GetCRLUpDates       -    .
*
*       - hStore      -  ()  
*                         crlBody     -   . 
*                         bodySize    -  
*
*      - thisUpdate  -  
*                         nextUpdate  -   
*                         
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLUpDates
                          (const hCERTSTORE hStore,
                           const unsigned char *crlBody,
                           const unsigned long bodySize,
                           char *thisUpdate,
                           char *nextUpdate);


/*
*   GetCRLIssuerInfo   -     CRL
*
*       - hStore   -  ()  
*                         crlBody  -  CRL
*                         bodySize - 
*
*      - DName     - DN (char[256])
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLIssuerInfo
                            (const hCERTSTORE hStore,
                             const unsigned char *crlBody,
                             const unsigned long bodySize,
                             char *DName);


/*
*   GetCRLDistrPoint    -    
*
*       - hStore   -  ()  
*                         crlBody  -  
*                         bodySize -  
*
*      - CApoint  - -  IP 
*                                       .
*                                      NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLDistrPoint
                            (const hCERTSTORE hStore,
                             const unsigned char *crlBody,
                             const unsigned long bodySize,
                             char *CApoint);


/*
*   GetCRLalterName   -     
*
*       - hStore   -  ()  
*                         crlBody  -  CRL
*                         bodySize - 
*
*      - DName     - DN (char[256])
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLalterName
                            (const hCERTSTORE hStore,
                             const unsigned char *crlBody,
                             const unsigned long bodySize,
                             char *DName);


/*
*   GetCRLIssuerNumber -       CRL
*
*       - hStore   -  ()  
*                         crlBody -   CRL
*                         bodySize - 
*
*      - serNum    -  
*                                        .
*                                       NULL,    .
*                         numSize   - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLIssuerNumber
                               (const hCERTSTORE hStore,
                                const unsigned char *crlBody,
                                const unsigned long bodySize,
                                unsigned char *serNum,
                                unsigned long *numSize);


/*
*   GetCRLSignature    -   
*
*       - hStore   -  ()  
*                         crlBody -   CRL
*                         bodySize - 
*
*      - sigOID   -   (char[32])
*                         sign     - 
*                         signSize - 
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCRLSignature(const hCERTSTORE hStore,
                             const unsigned char *crlBody,
                             const unsigned long bodySize,
                             char *sigOID,
                             unsigned char *sign,
                             unsigned long *signSize);


/*
*   GetCertSubjectInfo  -     
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - CName     - CN (char[64])
*                         DName     - DN (char[256])
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertSubjectInfo
                              (const hCERTSTORE hStore,
                               const unsigned char *certBody,
                               const unsigned long bodySize,
                               char *CName,
                               char *DName);

/*
*   GetCertIssuerInfo   -     
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - CName     - CN (char[64])
*                         DName     - DN (char[256])
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertIssuerInfo
                              (const hCERTSTORE hStore,
                               const unsigned char *certBody,
                               const unsigned long bodySize,
                               char *CName,
                               char *DName);

/*
*   GetCertValidInfo    -      
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - notBefore -   (char[16])
*                       - notAfter  -   (char[16])
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertValidInfo
                            (const hCERTSTORE hStore,
                             const unsigned char *certBody,
                             const unsigned long bodySize,
                             char *notBefore,
                             char *notAfter);

/*
*   GetCertSubjectKey   -   
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - keyOID   -    (char[32])
*                         key      -  
*                         keySize  -  
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertSubjectKey
                              (const hCERTSTORE hStore,
                               const unsigned char *certBody,
                               const unsigned long bodySize,
                               char *keyOID,
                               unsigned char *key,
                               unsigned long *keySize);

_WIN_DLL int GetCertSubjectKeyEx
                              (const hCERTSTORE hStore,
                               const unsigned char *certBody,
                               const unsigned long bodySize,
                               char *keyOID,
                               char *algOID,
                               unsigned char *key,
                               unsigned long *keySize);


/*
*   GetCertSignature    -   
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - sigOID   -   (char[32])
*                         sign     - 
*                         signSize - 
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertSignature
                              (const hCERTSTORE hStore,
                               const unsigned char *certBody,
                               const unsigned long bodySize,
                               char *sigOID,
                               unsigned char *sign,
                               unsigned long *signSize);


/*
*   GetDistributionPoint-       
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - CApoint  - -  IP 
*                       - CRLpoint - -  IP 
*                                       .
*                                      NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetDistributionPoint
                                (const hCERTSTORE hStore,
                                 const unsigned char *certBody,
                                 const unsigned long bodySize,
                                 char *CApoint,
                                 char *CRLpoint);


/*
*   GetOCSPPoint -   OCSP 
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - OCSPpoint - -  IP 
*                                       .
*                                      NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetOCSPPoint(const hCERTSTORE hStore,
                          const unsigned char *certBody,
                          const unsigned long bodySize,
                          char *OCSPpoint);



/*
*   GetTSAPoint -   TSA 
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - TSApoint - -  IP 
*                                       .
*                                      NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetTSAPoint(const hCERTSTORE hStore,
                         const unsigned char *certBody,
                         const unsigned long bodySize,
                         char *TSApoint);

/*
*   GetDVCSPoint -   DVCS 
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - DVCSpoint - -  IP 
*                                       .
*                                      NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetDVCSPoint(const hCERTSTORE hStore,
                          const unsigned char *certBody,
                          const unsigned long bodySize,
                          char *DVCSpoint);

/*
*   GetCertificateKeyID -      
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - keyID    -  
*                         idSize   - 
*                         caKeyID  -   
*                         caIdSize - 
*
*                                       .
*                                      NULL,    .
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertificateKeyID(const hCERTSTORE hStore,
                                const unsigned char *certBody,
                                const unsigned long certSize,
                                unsigned char *keyID,
                                unsigned long *idSize,
                                unsigned char *caKeyID,
                                unsigned long *caIdSize);


/*
*   GetCertSubjectNumber -      
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - serNum   -  
*                                       .
*                                      NULL,    .
*                         numSize  - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertSubjectNumber
                                (const hCERTSTORE hStore,
                                 const unsigned char *certBody,
                                 const unsigned long bodySize,
                                 unsigned char *serNum,
                                 unsigned long *numSize);

/*
*   GetCertIssuerNumber -       
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - serNum    -  
*                                        .
*                                       NULL,    .
*                         numSize   - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertIssuerNumber
                                (const hCERTSTORE hStore,
                                 const unsigned char *certBody,
                                 const unsigned long bodySize,
                                 unsigned char *serNum,
                                 unsigned long *numSize);


/*
*   GetCertIssuerPolicy -     
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - policyCount -  
*                         policyOID   -  OID 
*                         policyURL   -  URI,    . 
*                                           256 .
*                         policyOwner -   ,  . 
*                                           255 .
*                         policyText  -   ,    . 
*                                           200 .
*                                          .
*                                         NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertIssuerPolicy
                                (const hCERTSTORE hStore,
                                 const unsigned char *certBody,
                                 const unsigned long bodySize,
                                 int *policyCount,
                                 char **policyOID,
                                 char **policyURL,
                                 char **policyOwner,
                                 char **policyText);


/*
*   GetCertAltName      -     .
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*
*      - altCount -  
*                         altOID   -  OID 
*                                        32 .
*                         altName  -  . 
*                                        256 .
*                         
*              - 0    ,   myerror.h
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertAltName
                          (const hCERTSTORE hStore,
                           const unsigned char *certBody,
                           const unsigned long bodySize,
                           int *altCount,
                           char **altOID,
                           char **altName);


/*
*   CertCompareCRL     -    .
*
*       - hStore   -  ()  
*                         crlBody1  -  
*                         bodySize1 -  
*                         crlBody2  -  
*                         bodySize2 -  
*
*      - result <0 -  ; =0 - ; >0 -  .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtCompareCRL
                            (const hCERTSTORE hStore,
                             const unsigned char *crlBody1,
                             const unsigned long crlSize1,
                             const unsigned char *crlBody2,
                             const unsigned long crlSize2,
                             int *result);


/*
*   CertKeyCompare     -       .
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize - 
*
*      - keyClass - AT_SIGNATURE || AT_KEYEXCHANGE
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtKeyCompare
                          (const hCERTSTORE hStore,
                           const unsigned char *certBody,
                           const unsigned long bodySize,
                           unsigned long *keyClass);


/*
*   CertCreatePattern   -    .
*
*       - hStore    -  ()  
*                         DName     -   
*                         notBefore -   
*                         notAfter  -   
*                         keyOID    -   
*                         sigOID    -   
*                         keyBlob   -  
*                         keySize   - 
*                         Flag      - 
*
*      - certBody  -  
*                         bodySize  - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtCreatePattern
                              (const hCERTSTORE hStore,
                               const char *DName,
                               const char *notBefore,
                               const char *notAfter,
                               const char *keyOID,
                               const char *sigOID,
                               const unsigned char *keyBlob,
                               const unsigned long keySize,
                               const unsigned long Flag,
                               unsigned char *certBody,
                               unsigned long *bodySize);



/*
*   CertVerifyCRLRevocation -  / .
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*                         crlBody - 
*                         bodySize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyCRLRevocation
                                    (const hCERTSTORE hStore,
                                     const unsigned char *certBody,
                                     const unsigned long certSize,
                                     const unsigned char *crlBody,
                                     const unsigned long crlSize);


/*
*   CrtGetNumRevocReason -  /   s/n.
*
*       - hStore   -  ()  
*                         serNum - s/n 
*                         nimSize -  s/n
*                         crlBody - 
*                         bodySize -  
*
*      - reason  - 
*                       - revDate -    
*                       - invalidDate -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtGetNumRevocReason
                                (const hCERTSTORE hStore,
                                 const unsigned char *serNum,
                                 const unsigned long numSize,
                                 const unsigned char *crlBody,
                                 const unsigned long crlSize,
                                 int  *reason,
                                 char *revDate,
                                 char *invalidDate);


/*
*   CertGetRevocationReason -  / .
*
*       - hStore   -  ()  
*                         certBody -  
*                         bodySize -  
*                         crlBody - 
*                         bodySize -  
*
*      - reason  - 
*                       - revDate -    
*                       - invalidDate -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtGetRevocationReason
                                    (const hCERTSTORE hStore,
                                     const unsigned char *certBody,
                                     const unsigned long certSize,
                                     const unsigned char *crlBody,
                                     const unsigned long crlSize,
                                     int  *reason,
                                     char *revDate,
                                     char *invalidDate);


/*
*   GetSerialNumberFromCRL -      .
*
*       - hStore   -  ()  
*                         crlBody - 
*                         bodySize -  
*
*      - count   - 
*                       - revDate -     
*                       - serNum  -   
*                       - serNumSize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetSerialNumberFromCRL
                                  (const hCERTSTORE hStore,
                                   const unsigned char *crlBody,
                                   const unsigned long crlSize,
                                   int  *count,
                                   char **revDate,
                                   unsigned char **serNum,
                                   unsigned long *serNumSize);


/*
*   CertVerifySubjectCertificate -      
*                                      .
*
*       - hStore   -  ()  
*                         certBody -   
*                         certSize -  
*                         CABody -  
*                         caSize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifySubjectCertificate
                                          (const hCERTSTORE hStore,
                                           const unsigned char *certBody,
                                           const unsigned long certSize,
                                           const unsigned char *CABody,
                                           const unsigned long caSize);

/*
*   CertVerifyIsCA     -     .
*
*       - hStore   -  ()  
*                         CABody -  
*                         caSize -  
*
*      - caLevel - -    .  ==0,  Root
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyIsCA
                            (const hCERTSTORE hStore,
                             const unsigned char *CABody,
                             const unsigned long caSize,
                             int *caLevel);


/*
*   CertVerifyIsRoot    -      .
*
*       - hStore   -  ()  
*                         CABody -  
*                         caSize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyIsRoot
                            (const hCERTSTORE hStore,
                             const unsigned char *CABody,
                             const unsigned long caSize);


/*
*   CrtVerifyIsOCSP    -     OCSP .
*
*       - hStore   -  ()  
*                         crtBody -   
*                         crtSize -  
*
*      - ocspNoCheck -   OID    id-pkix-ocsp-nocheck.
*                         
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyIsOCSP(const hCERTSTORE hStore,
                             const unsigned char *crtBody,
                             const unsigned long crtSize,
                             bool *ocspNoCheck);


/*
*   CrtVerifyIsTSA      -     TSA .
*
*       - hStore   -  ()  
*                         crtBody -   
*                         crtSize -  
*
*      - .
*                         
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyIsTSA(const hCERTSTORE hStore,
                            const unsigned char *crtBody,
                            const unsigned long crtSize);

/*
*   CrtVerifyIsDVCS     -     DVCS .
*
*       - hStore   -  ()  
*                         crtBody -   
*                         crtSize -  
*
*      - .
*                         
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyIsDVCS(const hCERTSTORE hStore,
                             const unsigned char *crtBody,
                             const unsigned long crtSize);


/*
*   CrtVerifyIsRA       -     RA.
*
*       - hStore   -  ()  
*                         crtBody -   
*                         crtSize -  
*
*      - .
*                         
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtVerifyIsRA(const hCERTSTORE hStore,
                           const unsigned char *crtBody,
                           const unsigned long crtSize);


/*
*   CrtGetBasicConstraints -   .
*
*       - hStore   -  ()  
*                         crtBody  -   
*                         crtSize  -  
*
*      - isCA    -  
*                       - pathLen -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtGetBasicConstraints(const hCERTSTORE hStore,
                                   const unsigned char *crtBody,
                                   const unsigned long crtSize,
                                   bool *isCA, int *pathLen);


/*
*   CrtGetKeyUsage      -    .
*
*       - hStore   -  ()  
*                         crtBody  -   
*                         crtSize  -  
*
*      - keyUsage -   ()
*                       - extUsageCount - -   
*                       - extKeyUsage   -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtGetKeyUsage(const hCERTSTORE hStore,
                           const unsigned char *crtBody,
                           const unsigned long crtSize,
                           ulong32 *keyUsage,
                           int *extUsageCount,
                           char **extKeyUsage);

/*
*   CrtGetKeyUsageX      -    .
*
*       - hStore   -  ()  
*                         crtBody  -   
*                         crtSize  -  
*
*      - keyUsage -   ()
*                       - isCritical
*                       - extUsageCount - -   
*                       - extKeyUsage   -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtGetKeyUsageX(const hCERTSTORE hStore,
                            const unsigned char *crtBody,
                            const unsigned long crtSize,
                            ulong32 *keyUsage,
                            bool *isCritical,
                            int *extUsageCount,
                            char **extKeyUsage);

/*
*   CrtGetExtensions    -  OID  .
*
*       - hStore   -  ()  
*                         crtBody  - 
*                         crtSize  -  
*
*      - extCount -  
*                         extOIDs  - 
*                         
*              - 0    ,   myerror.h
*/
  int CrtGetExtensions(const hCERTSTORE hStore,
                       const unsigned char *crtBody,
                       const unsigned long crtSize,
                       int *extCount,
                       char **extOIDs);

/*
*   CrtGetCritical      -  OID   .
*
*       - hStore   -  ()  
*                         crtBody  - 
*                         crtSize  -  
*
*      - extCount -  
*                         extOIDs  - 
*                         
*              - 0    ,   myerror.h
*/
  int CrtGetCritical(const hCERTSTORE hStore,
                     const unsigned char *crtBody,
                     const unsigned long crtSize,
                     int *extCount,
                     char **extOIDs);


/*
*   CrtGetExtensionValue   -    .
*
*       - hStore   -  ()  
*                         crtBody  - 
*                         crtSize  -  
*                         extOIDs  - 
*
*      - criticalFlg
*                         extValue  - 
*                         extSize   - 
*                         
*              - 0    ,   myerror.h
*/
  int CrtGetExtensionValue(const hCERTSTORE hStore,
                           const unsigned char *crtBody,
                           const unsigned long crtSize,
                           const char *extOID, 
                           bool *criticalFlg, 
                           unsigned char *extValue, 
                           long *extSize);


/*
*   CrtGetUpCount       -     .
*
*       - hStore   -  ()  
*                         crtBody -   
*                         crtSize -  
*
*      - .
*                         
*              -  
*/
_WIN_DLL long CrtGetUpCount(const hCERTSTORE hStore,
                            const unsigned char *crtBody,
                            const unsigned long crtSize);

/*
*   CryptVerifyCertificateSignature -    .
*
*       - hStore   -  ()  
*                         certBody -   
*                         certSize -  
*                         CABody -  
*                         caSize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrptVerifyCertificateSignature
                                            (const hCERTSTORE hStore,
                                             const unsigned char *certBody,
                                             const unsigned long certSize,
                                             const unsigned char *CABody,
                                             const unsigned long caSize);


/*
*   CryptVerifyCRLSignature -   .
*
*       - hStore   -  ()  
*                         crlBody -  
*                         bodySize -  
*                         CABody -  
*                         caSize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrptVerifyCRLSignature
                                     (const hCERTSTORE hStore,
                                      const unsigned char *crlBody,
                                      const unsigned long crlSize,
                                      const unsigned char *CABody,
                                      const unsigned long caSize);



/*
*   CryptVerifyRootSignature -     .
*
*       - hStore   -  ()  
*                         CABody -  
*                         caSize -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrptVerifyRootSignature
                                    (const hCERTSTORE hStore,
                                     const unsigned char *CABody,
                                     const unsigned long caSize);


/*
*   GetTime             -      YYYYMMDDHHMMSSZ.
*
*       - .
*
*      -  .
*
*              - .
*/
_WIN_DLL int GetTime
                        (char *_time);


/*
*   GetTimePlusHour     -     
*
*       - hour.
*
*      -   + hour.
*
*              - .
*/
_WIN_DLL int GetTimePlusHour
                            (char *_time, int hour);



/*
*   SetTimePlusHour     -    .
*
*       - hour.
*
*      -  + hour.
*
*              - .
*/
_WIN_DLL int SetTimePlusHour
                              (char *_time, int hour);


/*
*   DN2struct           -  DN-  .
*/
_WIN_DLL int DN2struct
                      (char* dn, void *sdn);


/*
*   DN2format           -  DN- .
*/
_WIN_DLL int DN2format
                      (char* dn, char *fdn);

_WIN_DLL int DN2invert
                      (char* dn, char *fdn);



///////////////////////////////////////////////////////////////////////
/////////////////   ////////////////////////////
///////////////////////////////////////////////////////////////////////

//#ifdef __Open_CSP_func


/*
*   PKCSGetSlotsCount   -    PKCS#11
*
*       - pLibName      -  
*
*      - pulCount       - -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSGetSlotsCount(CHAR *pLibName,
                                 DWORD *pulCount);

/*
*   PKCSGetSlotsCount   -    PKCS#11
*
*       - pLibName      -  
*                         ulSlotNumber  -  
*
*      - slotDescription - char[64]
*                         slotManufacturerID - char [32]
*                         isTokenPresent  - 0/1
*                         tokenLabel      - char[32]
*                         tokenModel      - char[16]
*                         tokenManufacturerID - char[32]
*                         serialNumber    - char[16]
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSGetSlotInfo(CHAR *pLibName,
                               DWORD ulSlotNumber,
                               unsigned char *slotDescription,
                               unsigned char *slotManufacturerID,
                               bool *isTokenPresent,
                               unsigned char *tokenLabel,
                               unsigned char *tokenModel,
                               unsigned char *tokenManufacturerID,
                               unsigned char *serialNumber);

/*
*   PKCSAddCertificate  -   PKCS#11
*
*       - hProv -  PKCS#11
*                         certType      -  (CKC_X_509-0x0, CKC_CERTEX_HSM_CA - 0x8E000001, CKC_CERTEX_HSM_HSM - 0x8E000002)
*                         pLabel        - 
*                         pSubject      -      DN
*                         subjSize      -  
*                         pSerialNum    -   
*                         numSize       -   
*                         pCertificate  -  
*                         certSize      - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSAddCertificate(HCRYPTPROV hProv,
                                 DWORD certType, 
                                 CHAR  *pLabel, 
                                 UCHAR *pSubject, 
                                 DWORD  subjSize,
                                 UCHAR  *pSerialNum, 
                                 DWORD  numSize,
                                 UCHAR  *pCertificate, 
                                 DWORD  certSize);

/*
*   PKCSOpenContext     -   PKCS#11
*
*       - pLibName      -  
*                         ulSlotNumber  -  
*                         keyAlg        -  (CKK_RSA - 0x00000000, CKK_DSA - 0x00000001)
*                         keySize       -   ( - 1024 )
*                         pPin          -   
*                         ulPinLen      -  
*                         pszContainer  -  
*                         dwFlags       -     (0, CRYPT_NEWKEYSET, CRYPT_DELETEKEYSET)
*
*      - phProv        -  PKCS#11
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSOpenContext(HCRYPTPROV *phProv,
                               CHAR *pLibName,
                               DWORD ulSlotNumber,
                               DWORD keyAlg,
                               DWORD keySize,
                               UCHAR *pPin, 
                               DWORD ulPinLen,
                               CHAR *pContainer,
                               DWORD dwFlags);

/*
*   PKCSCloseContext    -   PKCS#11
*
*       - *hProv -  PKCS#11
*
*      - .
*
*              - 0    ,   myerror.h
*/_WIN_DLL DWORD PKCSCloseContext(HCRYPTPROV *phProv);



/*
*   sslGenKey           -     PKCS#12
*
*       - algID       -   (6-RSAEncrypt, 19-RSAMD5, 116-DSAEcrypt, 66,113-DSASHA1, 408-EC)
*                         keyBits     -   (512, 1024,2048 - RSA, 1024 - DSA, 714 - EC)
*                         sslCallback -  typedef void (*t_callback)(int,int,void *)
*                         pkcsPasswd  -   PKCS#12
*
*      - keyPKCS12   -     PKCS#12
*                         keySize     -   
*                         openKey     -  
*                         openSize    -   
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int sslGenKey
                      (const int algID,
                       const int keyBits,
                       t_callback sslCallback,
                       char *pkcsPasswd,
                       unsigned char *keyPKCS12,
                       unsigned long *keySize,
                       unsigned char *openKey,
                       unsigned long *openSize);

/*
*   sslCreatePKCS12     -  PKCS#12
*
*       - DName       -   
*                         pkcsPasswd  -   PKCS12
*                         keyPKCS12   -    PKCS12
*                         keySize     - 
*                         certBody    - ,  
*                         certSize    -
*                         caBody      -  
*                         caSize      -
*
*      - pkcs12      - PKCS12
*                         pkcsSize    -   
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int sslCreatePKCS12
                            (char *DName,
                             char *pkcsPasswd,
                             unsigned char *keyPKCS12,
                             unsigned long keySize,
                             unsigned char *certBody,
                             unsigned long certSize,
                             unsigned char *caBody,
                             unsigned long caSize,
                             unsigned char *pkcs12,
                             unsigned long *pkcsSize);


/*
*   sslPKCS12toDER        - PKCS -> DER
*
*       - pkcsPasswd  - 
*                         pkcs12      - PKCS12
*                         pkcsSize    - 
*
*      - keyDER      -     DER
*                         keySize     - 
*                         certDER     -     DER
*                         certSize    - 
*                         caDER       -      DER
*                         caSize      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int sslPKCS12toDER
                          (const char *pkcsPasswd,
                           const unsigned char *pkcs12,
                           const unsigned long pkcsSize,
                           unsigned char *keyDER,
                           unsigned long *keySize,
                           unsigned char *certDER,
                           unsigned long *certSize,
                           unsigned char *caDER,
                           unsigned long *caSize);

/*
*   sslPKCS12toPEM      - PKCS -> PEM
*
*       - pkcsPasswd  - 
*                         pkcs12      - PKCS12
*                         pkcsSize    - 
*
*      - keyPEM      -     PEM
*                         keySize     - 
*                         certPEM     -     PEM
*                         certSize    - 
*                         caPEM       -      PEM
*                         caSize      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int sslPKCS12toPEM
                           (const char *pkcsPasswd,
                            const unsigned char *pkcs12,
                            const unsigned long pkcsSize,
                            unsigned char *keyPEM,
                            unsigned long *keySize,
                            unsigned char *certPEM,
                            unsigned long *certSize,
                            unsigned char *caPEM,
                            unsigned long *caSize);

/*
*   CSPOpenContext      -   
*
*       - pszContainer  -  
*                         dwProvType    -  
*                         dwProvParam   -   -   
*                         dwFlags       -    
*
*      - phProv        -  
*                         phLib         -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD CSPOpenContext
                              (HCRYPTPROV *phProv,
                               CHAR *pszContainer,
                               DWORD dwProvType,
                               DWORD dwProvParam,
                               DWORD dwFlags,
                               BYTE * pbSignature,
                               DWORD dwSigLen,
                               BYTE * pbContainer,
                               DWORD * dwContLen,
                               HINSTANCE *phLib);

/*
*   CSPOpenContextEx      -   
*
*       - pszContainer  -  
*                         dwProvType    -  
*                         dwProvParam   -   -   
*                         dwFlags       -    
*                         pszCSPLib     -    
*
*      - phProv        -  
*                         phLib         -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD CSPOpenContextEx
                              (HCRYPTPROV *phProv,
                               CHAR *pszContainer,
                               DWORD dwProvType,
                               DWORD dwProvParam,
                               DWORD dwFlags,
                               CHAR *pszCSPLib,
                               HINSTANCE *phLib);


/*
*   CSPCloseContext   -   
*
*       - hProv -   
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPCloseContext
                              (HCRYPTPROV *phProv);


/*
*   CSPSetProvParam   -   
*
*       - param   - 
*                         pbData  -
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPSetProvParam
                            (DWORD param,
                             BYTE  *pbData);



/*
*   CSPSetProvParamEx   -   
*
*       - hProv   -   
*                         param   - 
*                         pbData  -
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPSetProvParamEx
                            (HCRYPTPROV hProv,
                             DWORD param,
                             BYTE  *pbData);


/*
*   CSPGetKeyParam      -   
*
*       - hProv     -   
*                         keySpec   - 
*                         keyParam  - 
*                         
*      - dataKey   -
*                         dataSize  -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPGetKeyParam
                           (HCRYPTPROV hProv,
                            const unsigned long keySpec,
                            const unsigned long keyParam,
                            unsigned char *dataKey,
                            unsigned long *dataSize);

/*
*   CSPSetKeyParam      -   
*
*       - hProv     -   
*                         keySpec   - 
*                         keyParam  - 
*                         dataKey   -
*                         dataSize  -
*
*      - 
*                         
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPSetKeyParam
                           (HCRYPTPROV hProv,
                            const unsigned long keySpec,
                            const unsigned long keyParam,
                            unsigned char *dataKey,
                            unsigned long dataSize);


/*
*   CSPOIDInfo          -     
*
*       - AlgId
*
*      - count
*                         algName
*                         algOID
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int   CSPOIDInfo
                      (ALG_ID AlgId,
                       int *count,
                       char **algName,
                       char **algOID);


/*
*   CSPOIDtoHashOID     -    OID  Hash OID
*
*       - OID
*
*      - hashOID
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPOIDtoHashOID
                            (const char *OID,
                             char *hashOID);


/*
*   CSPOIDtoHashOIDex   -    OID  Hash OID
*
*       - hProv     -   
*                         OID       -  
*
*      - hashOID   -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPOIDtoHashOIDex(HCRYPTPROV hProv,
                              const char *OID,
                              char *hashOID);

/*
*   CSPOIDtoAlgId       -    OID  AlgID
*
*       - OID
*
*      - AlgId
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPOIDtoAlgId
                          (const char *OID,
                           ALG_ID *AlgId);

/*
*   CSPAlgIdtoOID       -    OID  AlgID
*
*       - AlgId
*
*      - OID
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPAlgIdtoOID
                          (const ALG_ID AlgId,
                           char *OID);


/*
*   CSPAlgClassToOID    -    OID  AlgID
*
*       - AlgId
*
*      - OID
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPAlgClassToOID
                            (ALG_ID AlgId,
                             char *OID);


/*
*   CSPGetProviderParam -   
*
*       - hProv -   
*                         param -
*
*      - paramBuf   -
*                         paramSize  -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPGetProviderParam
                                (HCRYPTPROV hProv,
                                 unsigned long param,
                                 unsigned char *paramBuf,
                                 unsigned long *paramSize);



/*
*   CSPGetContainersName -     
*
*        - hProv    -   
*
*       - count    -
*                          contName -
*
*               - 0    ,   myerror.h
*/
_WIN_DLL int CSPGetContainersName
                                 (HCRYPTPROV hProv,
                                  unsigned int *count,
                                  char **contName);


/*
*   CSPRandomSess       -    
*
*       - hProv -   
*                         keyOID
*
*      - randBuf
*                         bufSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPRandomSess
                          (HCRYPTPROV hProv,
                           const char *keyOID,
                           unsigned char *randBuf,
                           unsigned long *bufSize);


/*
*   CSPHashPublicKey     -       ( )
*
*       - hProv -   
*                         keySpec
*                         hashOID
*
*      - serNum
*                         numSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPHashPublicKey
                            (HCRYPTPROV hProv,
                             const unsigned long keySpec,
                             const char *hashOID,
                             unsigned char *keyHash,
                             unsigned long *hashSize);

/*
*   PKCSHashPublicKey   -       ( )
*
*       - hProv -   PKCS#11
*
*      - serNum
*                         numSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSHashPublicKey(HCRYPTPROV hProv,
                                unsigned char *keyHash,
                                unsigned long *hashSize);


/*
*   CSPGetHash          -     
*
*       - hProv     -   
*                         hashOID   - ( szOID_TGR3411        "1.3.6.1.4.1.6801.1.2.1")
*                         Final     -   
*                         strReq    -  
*                         reqSize   - 
*
*      - strHash   - -
*                         hashSize  - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPGetHash
                        (HCRYPTPROV hProv,
                         const char *hashOID,
                         const bool Final,
                         const unsigned char *strReq,
                         const unsigned long reqSize,
                         unsigned char *strHash,
                         unsigned long *hashSize);

/*
*   PKCSGetHash         -     
*
*       - hProv   -   PKCS#11
*                         hashAlg - CKM_SHA_1  ..
*                         Final   -   
*                         strReq
*                         reqSize
*
*      - strHash
*                         hashSize
*
*              - 0    ,   myerror.h
*/
DWORD PKCSGetHash(HCRYPTPROV hProv,
                  DWORD hashAlg,
                  bool Final,
                  UCHAR *strReq,
                  DWORD reqSize,
                  UCHAR *strHash,
                  DWORD *hashSize);


/*
*   CSPGetContainersName -     
*
*        - hProv    -   
*
*       - count    -
*                          contName -
*
*               - 0    ,   myerror.h
*/
_WIN_DLL int CSPGetContainersName
                                 (HCRYPTPROV hProv,
                                  unsigned int *count,
                                  char **contName);


/*
*   CSPRandomSess       -    
*
*       - hProv -   
*                         keyOID
*
*      - randBuf
*                         bufSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPRandomSess
                          (HCRYPTPROV hProv,
                           const char *keyOID,
                           unsigned char *randBuf,
                           unsigned long *bufSize);



/*
*   CSPExportKeyPair    -    
*
*       - hProv       -   
*                         keySpec     - 
*                         openKeyBlob - 
*                         openKeySize - 
*
*      - keyBlob     -
*                         blobSize    -
*                         openKeyHash -
*                         openKeyhSize-
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPExportKeyPair
                            (HCRYPTPROV hProv,
                             const unsigned long keySpec,
                             const unsigned char *openKeyBlob,
                             const unsigned long openKeySize,
                             unsigned char *keyBlob,
                             unsigned long *blobSize,
                             unsigned char *openKeyHash,
                             unsigned long *openKeyhSize);

/*
*   CSPImportKeyPair    -       
*
*       - hProv       -   
*                         Container   - 
*                         UserName    - 
*                         openKeyHash -
*                         openKeyhSize-
*                         blobExch    - 
*                         blobExchLen - 
*                         blobSign    - 
*                         blobSignLen - 
*
*      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPImportKeyPair
                            (HCRYPTPROV hProv,
                             const char *Container, 
                             const char *UserName, 
                             const unsigned char *openKeyHash,
                             const unsigned long openKeyhSize,
                             const unsigned char *blobExch, 
                             const unsigned long blobExchLen, 
                             const unsigned char *blobSign, 
                             const unsigned long blobSignLen);


/*
*   CSPExPassKeyPair    -       
*
*       - hProv    -   
*                         keySpec  - 
*                         cryptOID - 
*                         hashOID  - 
*                         passWord -
*
*      - keyBlob     -
*                         blobSize    -
*                         sesKeyHash  -
*                         sesKeyhSize -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPExPassKeyPair
                             (HCRYPTPROV hProv,
                              const unsigned long keySpec,
                              const char *cryptOID,
                              const char *hashOID,
                              const char *passWord,
                              unsigned char *keyBlob,
                              unsigned long *blobSize,
                              unsigned char *sesKeyHash,
                              unsigned long *sesKeyhSize);


/*
*   CSPImPassKeyPair    -       
*
*       - hProv       -
*                         Container   - 
*                         UserName    - 
*                         cryptOID    -
*                         hashOID     -
*                         passWord    -
*                         sesKeyHash  -
*                         sesKeyhSize -
*                         blobExch    - 
*                         blobExchLen - 
*                         blobSign    - 
*                         blobSignLen - 
*
*      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPImPassKeyPair
                             (HCRYPTPROV hProv,
                              const char *Container, 
                              const char *UserName, 
                              const char *cryptOID,
                              const char *hashOID,
                              const char *passWord,
                              const unsigned char *sesKeyHash,
                              const unsigned long sesKeyhSize,
                              const unsigned char *blobExch, 
                              const unsigned long blobExchLen, 
                              const unsigned char *blobSign, 
                              const unsigned long blobSignLen);



/*
*   CSPExportPublicKey  -     
*
*       - hProv -   
*                         keySpec
*
*      - keyBlob
*                         blobSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPExportPublicKey
                        (HCRYPTPROV hProv,
                         const unsigned long keySpec,
                         unsigned char *keyBlob,
                         unsigned long *blobSize);

/*
*   CSPExportPKCS12     -      PKCS#12
*
*       - hProv -   
*                         keySpec -
*                         passwd  - 
*
*      - keyBlob
*                         blobSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPExportPKCS12(HCRYPTPROV hProv,
                            const unsigned long keySpec,
                            const char *passwd,
                            unsigned char *keyBlob,
                            unsigned long *blobSize);


/*
*   PKCSExportPublicKey -      
*
*       - hProv -   PKCS#11
*
*      - keyBlob
*                         blobSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSExportPublicKey(HCRYPTPROV hProv,
                                  UCHAR *keyBlob,
                                  DWORD *blobSize);

/*
*   PackUserKey         -     
*
*       - hProv     -   
*                         version   -  
*                         DName     -   
*                         certExch  -    
*                         exchSize  -  
*                         certSign  -    
*                         signSize  -  
*                         openCAKey -    
*                         keySize   -   
*                         passWord  -   (,   openCAKey)
*                         keyName   -    
*
*      - keyInfo     -   
*                         keyInfoSize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int PackUserKey
                        (HCRYPTPROV hProv,
                         const int version,
                         const char *DName,
                         const char *keyName,
                         const unsigned char *certExch,
                         const unsigned long exchSize,
                         const unsigned char *certSign,
                         const unsigned long signSize,
                         const char *passWord,
                         const unsigned char *openCAKey,
                         const unsigned long keySize,
                         unsigned char *keyInfo,
                         unsigned long *keyInfoSize);


/*
*   PackUserKeyInfo     -       
*
*       - keyInfo     -   
*                         keyInfoSize -  
*                         
*
*      - version   -  
*                         DName     -   
*                         keyName   -    
*                         packTime  -   
*                         packOID   -  
*                                     CERTEX_SECRET_KEY_BACKUP_PASS -    
*                                     CERTEX_SECRET_KEY_BACKUP_EXCH -     
*                         certExch  -    
*                         exchSize  -  
*                         certSign  -    
*                         signSize  -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int PackUserKeyInfo
                            (const unsigned char *keyInfo,
                             const unsigned long keyInfoSize,
                             int  *version,
                             char *DName,
                             char *keyName,
                             char *packTime,
                             char *packOID,
                             unsigned char *certExch,
                             unsigned long *exchSize,
                             unsigned char *certSign,
                             unsigned long *signSize);


/*
*   UnpackUserKey     -   
*
*       - hProv     -   
*                         keyInfo     -   
*                         keyInfoSize -  
*                         passWord  -   (,  CERTEX_SECRET_KEY_BACKUP_EXCH)
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int UnpackUserKey
                          (HCRYPTPROV hProv,
                           const unsigned char *keyInfo,
                           const unsigned long keyInfoSize,
                           const char *passWord);



/*
*   CSPCheckImit        -  
*
*       - hProv -   
*                         hashOID
*                         openKeyBlob
*                         openSize
*                         strReq
*                         reqSize
*                         strImit
*                         imitSize
*                         sesKeyBlob
*                         sesSize
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPCheckImit
                        (HCRYPTPROV hProv,
                         const char *hashOID,
                         const unsigned char *openKeyBlob,
                         const unsigned long openSize,
                         const unsigned char *strReq,
                         const unsigned long reqSize,
                         const unsigned char *strImit,
                         const unsigned long imitSize,
                         const unsigned char *sesKeyBlob,
                         const unsigned long sesSize);



/*
*   CSPSetImit          -  
*
*       - hProv -   
*                         cryptOID
*                         hashOID
*                         cKeyBlob
*                         openKeyBlob
*                         openSize
*                         strReq
*                         reqSize
*
*      - strImit
*                         imitSize
*                         sesKeyBlob
*                         sesSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPSetImit
                      (HCRYPTPROV hProv,
                       const char *cryptOID,
                       const char *hashOID,
                       const int cKeyBlob,
                       const unsigned char **openKeyBlob,
                       const unsigned long *openSize,
                       const unsigned char *strReq,
                       const unsigned long reqSize,
                       unsigned char *strImit,
                       unsigned long *imitSize,
                       unsigned char **sesKeyBlob,
                       unsigned long *sesSize);


/*
*   CSPEncrypt          - 
*
*       - hProv -   
*                         cryptOID
*                         cKeyBlob
*                         openKeyBlob
*                         openSize
*                         mData
*                         lData
*
*      - mData
*                         sesKeyBlob
*                         sesSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPEncrypt
                      (HCRYPTPROV hProv,
                       const char *cryptOID,
                       const int cKeyBlob,
                       const unsigned char **openKeyBlob,
                       const unsigned long *openSize,
                       unsigned char *mData,
                       unsigned long lData,
                       unsigned char **sesKeyBlob,
                       unsigned long *sesSize);



/*
*   CSPDecrypt          - 
*
*       - hProv -   
*                         cryptOID
*                         openKeyBlob
*                         openSize
*                         mData
*                         lData
*                         sesKeyBlob
*                         sesSize
*
*      - mData
*
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPDecrypt
                       (HCRYPTPROV hProv,
                        const char *cryptOID,
                        unsigned char *openKeyBlob,
                        unsigned long openSize,
                        unsigned char *mData,
                        unsigned long lData,
                        unsigned char *sesKeyBlob,
                        unsigned long sesSize);


/*
*   CSPSetSign          - 
*
*       - hProv -   
*                         hashOID
*                         keySpec
*                         strReq
*                         reqSize
*
*      - strSig
*                         sigSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPSetSign
                      (HCRYPTPROV hProv,
                       const char *hashOID,
                       const unsigned long keySpec,
                       const unsigned char *strReq,
                       const unsigned long reqSize,
                       unsigned char *strSig,
                       unsigned long *sigSize);


/*
*   CSPSetSign          - 
*
*       - hProv -   PKCS#11
*                         hashAlg
*                         Final
*                         strReq
*                         reqSize
*
*      - strSig
*                         sigSize
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSSetSign(HCRYPTPROV hProv,
                          DWORD hashAlg,
                          bool Final,
                          UCHAR *strReq,
                          DWORD reqSize,
                          UCHAR *strSig,
                          DWORD *sigSize);

/*
*   CSPCheckSign        -  
*
*       - hProv -   
*                         hashOID
*                         strReq
*                         reqSize
*                         strSig
*                         sigSize
*                         openKeyBlob
*                         openSize
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CSPCheckSign
                        (HCRYPTPROV hProv,
                         const char *hashOID,
                         const unsigned char *strReq,
                         const unsigned long reqSize,
                         const unsigned char *strSig,
                         const unsigned long sigSize,
                         const unsigned char *openKeyBlob,
                         const unsigned long openSize);

/*
*   CSPCheckSign        -  
*
*       - hProv -   
*                         hashAlg
*                         Final
*                         strReq
*                         reqSize
*                         strSig
*                         sigSize
*                         openKeyBlob
*                         openSize
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL DWORD PKCSCheckSign(HCRYPTPROV hProv,
                            DWORD hashAlg,
                            bool Final,
                            UCHAR *strReq,
                            DWORD reqSize,
                            UCHAR *strSig,
                            DWORD sigSize,
                            UCHAR *openKeyBlob,
                            DWORD openSize);

//#endif  // __Open_CSP_func

//**********************************************************************************
//**********************************************************************************

/*
*   CreatePKCS10        -  PKCS#10
*
*       - hEnroll - 
*                         DName   -      DN
*                         Usage   -    - 
*                         sigOID  -  
*
*      - pPKCS10    -      
*                         pLenPKCS10 -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CreatePKCS10
                          (const hENROLLCONTEXT hEnroll,
                           const char *DName,
                           const char *Usage,
                           const char *sigOID,
                           unsigned char *pPKCS10,
                           unsigned long *pLenPKCS10);

/*
*   sslCreatePKCS10     -  PKCS#10
*
*       - hEnroll   - 
*                         DName     -      DN
*                         sigOID    -  
*                         pkcsPasswd- 
*                         keyPKCS12 - 
*                         keySize   - 
*
*      - pPKCS10    -      
*                         pLenPKCS10 -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int sslCreatePKCS10(const hENROLLCONTEXT hEnroll,
                            const char *DName,
                            const char *sigOID,
                            const char *pkcsPasswd,
                            const unsigned char *keyPKCS12,
                            const unsigned long keySize,
                            unsigned char *pPKCS10,
                            unsigned long *pLenPKCS10);


/*
*   sslCreatePKCS7      -  PKCS#7
*
*       - inData      -   ( PKCS#10)
*                         inSize      - 
*                         pkcsPasswd  - 
*                         keyPKCS12   - 
*                         keySize     - 
*
*      - outData    -   (PKCS#7)
*                         outSize    -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int sslCreatePKCS7(const unsigned char *inData, 
                           const unsigned long inSize,
                           const char *pkcsPasswd,
                           const unsigned char *keyPKCS12,
                           const unsigned long keySize,
                           unsigned char *outData,
                           unsigned long *outSize);

/*
*   sslVerifyPKCS7      -  PKCS#7
*
*       - inData      -   (PKCS#7)
*                         inSize      - 
*
*      - outData    - . 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int sslVerifyPKCS7
                          (const unsigned char *inData, 
                           const unsigned long inSize);

/*
*   SetPKCS10PKCS11     -  PKCS#11
*
*       - hEnroll - 
*                         hProv   -  PKCS11
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetPKCS10PKCS11(const hENROLLCONTEXT hEnroll,
                             const HCRYPTPROV hProv);

/*
*   VerifyPKCS10        -   PKCS#10
*
*       - hEnroll - 
*                         pPKCS10 -  c 
*                         LenPKCS10 -  
*                         Flags
*
*      - DName    -      DN
*                         sigOID   -  
*                         keyOID   -    - 
*                         hashKeyBlob -
*                         hashSize    -
*                         keyBlob     -
*                         keySize     -
*                         result      -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int VerifyPKCS10
                        (const hENROLLCONTEXT hEnroll,
                         const unsigned char *pPKCS10,
                         const unsigned long LenPKCS10,
                         const int Flags,
                         char *DName,
                         char *sigOID,
                         char *keyOID,
                         unsigned char *hashKeyBlob,
                         unsigned long *hashSize,
                         unsigned char *keyBlob,
                         unsigned long *keySize,
                         int *result);

/*
*   SetPKCS10Usage      -     
*
*       - hEnroll     - 
*                         keyUsage    -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetPKCS10Usage(const hENROLLCONTEXT hEnroll,
                           ulong32 keyUsage);


/*
*   SetPKCS10UsageX     -     
*
*       - hEnroll     - 
*                         isCritical  - 
*                         keyUsage    -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetPKCS10UsageX(const hENROLLCONTEXT hEnroll,
                             const bool isCritical,
                             ulong32 keyUsage);


/*
*   GetPKCS10Usage      -     
*
*       - hEnroll     - 
*
*      - keyUsage    -  :
*
*                                       INFRA_VAL_EXTN_KEYUSAGE_DIGSIGN  0x0080
*                                       INFRA_VAL_EXTN_KEYUSAGE_NONREPU  0x0040
*                                       INFRA_VAL_EXTN_KEYUSAGE_KEYENCH  0x0020
*                                       INFRA_VAL_EXTN_KEYUSAGE_DATAENC  0x0010
*                                       INFRA_VAL_EXTN_KEYUSAGE_KEYAGRM  0x0008
*                                       INFRA_VAL_EXTN_KEYUSAGE_CERTSIG  0x0004
*                                       INFRA_VAL_EXTN_KEYUSAGE_CRLSIGN  0x0002
*                                       INFRA_VAL_EXTN_KEYUSAGE_ENCONLY  0x0001
*                                       INFRA_VAL_EXTN_KEYUSAGE_DECONLY  0x8000
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetPKCS10Usage(const hENROLLCONTEXT hEnroll,
                            bool *isCritical,
                            ulong32 *keyUsage);


/*
*   SetPKCS10NetScape   -    
*
*       - hEnroll         - 
*                         typeNetScape    -  
*                                           NETSCAPE_SSL_CLIENT					0x80
*                                           NETSCAPE_SSL_SERVER					0x40
*                                           NETSCAPE_SMIME							0x20
*                                           NETSCAPE_OBJECT_SIGNING			0x10
*                                           NETSCAPE_SSL_CA							0x04
*                                           NETSCAPE_SMIME_CA						0x02
*                                           NETSCAPE_OBJECT_SIGNING_CA	0x01
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetPKCS10NetScape(const hENROLLCONTEXT hEnroll,
                               ulong32 typeNetScape);


/*
*   GetPKCS10NetScape   -    
*
*       - hEnroll     - 
*
*      - typeNetScape    -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetPKCS10NetScape(const hENROLLCONTEXT hEnroll,
                              ulong32 *typeNetScape);


/*
*   SetKeySpec          -    AT_EXCHANGE AT_SIGNATURE
*
*       - hEnroll - 
*                         spec   -  
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetKeySpec
                        (const hENROLLCONTEXT hEnroll,
                         unsigned long spec);



/*
*   SetCertTemplate     -   
*
*       - hEnroll - 
*                         TName   -     DN
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetCertTemplate(const hENROLLCONTEXT hEnroll,
                             char *TName);


/*
*   GetCertTemplate     -   
*
*       - hEnroll -                         
*
*      - TName   -     DN
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertTemplate(const hENROLLCONTEXT hEnroll,
                             char *TName);


/*
*   GetPKCS10AltName    -      PKCS#10
*
*       - hEnroll - 
*
*      - altCount -  
*                         altOID   -    OID 
*                                      32 .
*                         altName  -    . 
*                                      256 .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetPKCS10AltName
                             (const hENROLLCONTEXT hEnroll,
                              int *altCount,
                              char ***altOID,
                              char ***altName);

/*
*   SetPKCS10AltName    -      PKCS#10
*
*       - hEnroll - 
*                       - altCount -  
*                         altOID   -  OID 
*                                      32 .
*                         altName  -  . 
*                                      256 .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetPKCS10AltName(const hENROLLCONTEXT hEnroll,
                             int altCount,
                             char **altOID,
                             char **altName);


/*
*   SetPKCS10ExtUsage   -       PKCS#10
*
*       - hEnroll - 
*                       - extUsageCount -  
*                         extUsage      -    OID
*                                             32 .
*                                         INFRA_VAL_EXTN_EXTNKEYUSAGE_SERV "1.3.6.1.5.5.7.3.1"
*                                         INFRA_VAL_EXTN_EXTNKEYUSAGE_CLNT "1.3.6.1.5.5.7.3.2"
*                                         INFRA_VAL_EXTN_EXTNKEYUSAGE_CODS "1.3.6.1.5.5.7.3.3"
*                                         INFRA_VAL_EXTN_EXTNKEYUSAGE_EMAL "1.3.6.1.5.5.7.3.4"
*                                         INFRA_VAL_EXTN_EXTNKEYUSAGE_TSTM "1.3.6.1.5.5.7.3.8"
*                                         INFRA_VAL_EXTN_EXTNKEYUSAGE_OCSP "1.3.6.1.5.5.7.3.9"
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetPKCS10ExtUsage(const hENROLLCONTEXT hEnroll,
                              int extUsageCount,
                              char **extUsage);



/*
*   GetPKCS10ExtUsage   -       PKCS#10
*
*       - hEnroll - 
*
*      - extUsageCount -  
*                         extUsage      -    OID
*                                             32 .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetPKCS10ExtUsage(const hENROLLCONTEXT hEnroll,
                              int *extUsageCount,
                              char **extUsage);

/*
*   SetPKCS10Ext        -      PKCS#10
*
*       - hEnroll - 
*
*      - extCount -  
*                         extOID   -    OID
*                                      32 .
*                         extValue -    . 
*                                      256 .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetPKCS10Ext(const hENROLLCONTEXT hEnroll,
                          int extCount,
                          char **extOID,
                          char **extValue);

/*
*   GetPKCS10Ext        -      PKCS#10
*
*       - hEnroll - 
*
*      - crtExtSize -   
*                         crtExt     -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetPKCS10Ext(const hENROLLCONTEXT hEnroll,
                          unsigned long *crtExtSize,
                          unsigned char **crtExt);


/*
*   CreateEnroll        -    Enroll
*
*       - hProv     -   
*                         hContext  -  ()     
*
*      - hEnroll - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CreateEnroll
                         (HCRYPTPROV hProv,
                          hCERTCONTEXT hContext,
                          hENROLLCONTEXT *hEnroll);



/*
*   ReleaseEnroll       -    Enroll
*
*       - hEnroll - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ReleaseEnroll
                          (hENROLLCONTEXT *phEnroll);


//////////////////////////////////////////////////////////////////////////////////


/*
*   CreatePKIContext   -    CMC
*
*       - hPKI - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CreatePKIContext
                            (hPKICONTEXT *hPKI);


/*
*   TypeRequest         -   CMC 
*
*       - hPKI      - 
*                         cmcBlob   - 
*                         sizeBlob  -  
*
*      - reqType   -  - 0, 1, 2, 3
*                         transID   -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int TypeRequest
                        (hPKICONTEXT hPKI,
                         const unsigned char *cmcBlob,
                         const unsigned long sizeBlob,
                         int *reqType,
                         char *transID);




/*
*   KeyStoreRequest     -  CMC    
*
*       - hPKI        - 
*                         keySecure   -     TCont
*                         keySecSize  -  
*                         DName       -   
*                         transID     -  
*
*      - cmcBlob   -  - 
*                         sizeBlob  -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int KeyStoreRequest
                            (hPKICONTEXT hPKI,
                             const unsigned char *keySecure,
                             const unsigned long keySecSize,
                             const char *DName,
                             const char *transID,
                             unsigned char **cmcBlob,
                             unsigned long *sizeBlob);




/*
*   ViewKeyStoreRequest -  CMC    
*
*       - hPKI      - 
*                         cmcBlob   - 
*                         sizeBlob  -  
*
*      - DName     - ,   ,        NULL
*                         transID   -  
*                         keySecure -    TCont
*                         keySize   - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ViewKeyStoreRequest
                                (hPKICONTEXT hPKI,
                                 const unsigned char *cmcBlob,
                                 const unsigned long sizeBlob,
                                 char *DName,
                                 char *transID,
                                 unsigned char *keySecure,
                                 unsigned long *keySize);


/*
*   CertRequest         -  CMC   
*
*       - hPKI      - 
*                         pkscSign  -     
*                         pkcsSignSize -  
*                         pkcsExch  -      
*                         pkcsExchSize -  
*                         DName     -        NULL
*                         transID   -  
*
*      - cmcBlob   -  - 
*                         sizeBlob  -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtRequest
                        (hPKICONTEXT hPKI,
                         const unsigned char *pkscSign,
                         const unsigned long pkcsSignSize,
                         const unsigned char *pkcsExch,
                         const unsigned long pkcsExchSize,
                         const char *DName,
                         const char *transID,
                         unsigned char **cmcBlob,
                         unsigned long *sizeBlob);


/*
*   ViewCertRequest         -  CMC   
*
*       - hPKI      - 
*                         cmcBlob   - 
*                         sizeBlob  -  
*
*      - DName     - ,   ,        NULL
*                         reqCount  - k  ( 2)
*                         request   -  
*                         size      -   
*                         transID   -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ViewCertRequest
                            (hPKICONTEXT hPKI,
                             const unsigned char *cmcBlob,
                             const unsigned long sizeBlob,
                             char *DName,
                             int *reqCount,
                             unsigned char **request,
                             unsigned long *size,
                             char *transID);


/*
*   CertRevoke          -  CMC    
*
*       - hPKI        - 
*                         crtSign     -   
*                         crtSignSize - 
*                         crtExch     -    
*                         crtExchSize - 
*                         revReason   -  
*                         revDate     -  
*                         DName       -   
*                         Comment     - 
*                         transID     -  
*
*      - cmcBlob   -  - 
*                         sizeBlob  -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtRevoke
                      (hPKICONTEXT hPKI,
                      const unsigned char *crtSign,
                      const unsigned long crtSignSize,
                      const unsigned char *crtExch,
                      const unsigned long crtExchSize,
                      const int revReason,
                      const char *revDate,
                      const char *DName,
                      const char *Comment,
                      const char *transID,
                      unsigned char **cmcBlob,
                      unsigned long *sizeBlob);


/*
*   ViewCertRevoke      -  CMC    
*
*       - hPKI      - 
*                         cmcBlob   - 
*                         sizeBlob  -  
*
*      - serNum      -    
*                         serNumSize  -  
*                         IssuerName  -   
*                         revReason   -  
*                         strRevReason-  
*                         revDate     -  
*                         DName       -   
*                         Comment     -   (256)
*                         transID     -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ViewCertRevoke
                          (hPKICONTEXT hPKI,
                          const unsigned char *cmcBlob,
                          const unsigned long sizeBlob,
                          unsigned char **serNum,
                          unsigned long *serNumSize,
                          char *IssuerName,
                          int  *revReason,
                          char *strRevReason,
                          char *revDate,
                          char *DName,
                          char *Comment,
                          char *transID);

/*
*   CertChange          -  CMC    
*
*       - hPKI        - 
*                         crtSign     -   
*                         crtSignSize - 
*                         crtExch     -    
*                         crtExchSize - 
*                         revReason   -  
*                         revDate     -  
*                         DName       -   
*                         Comment     -   (256)
*                         pkscSign    -     
*                         pkcsSignSize -  
*                         pkcsExch    -      
*                         pkcsExchSize -  
*                         transID     -  
*
*      - cmcBlob   -  - 
*                         sizeBlob  -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrtChange
                      (hPKICONTEXT hPKI,
                       const unsigned char *crtSign,
                       const unsigned long crtSignSize,
                       const unsigned char *crtExch,
                       const unsigned long crtExchSize,
                       const int revReason,
                       const char *revDate,
                       const char *DName,
                       const char *Comment,
                       const unsigned char *pkscSign,
                       const unsigned long pkcsSignSize,
                       const unsigned char *pkcsExch,
                       const unsigned long pkcsExchSize,
                       const char *transID,
                       unsigned char **cmcBlob,
                       unsigned long *sizeBlob);


/*
*   ReleasePKIContext   -    CMC
*
*       - hPKI - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ReleasePKIContext
                              (hPKICONTEXT *phPKI);


////////////////////////////////////////////////////////////////////
//////////////////// MESSAGE FUNCTIONS /////////////////////////////
////////////////////////////////////////////////////////////////////

/*
*   AuthMsgOpen        -     authfunc
*
*       - hProv -   
*                         Flag  - 
*
*      - phAuth - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AuthMsgOpen
                        (HCRYPTPROV hProv,
                         int Flags,
                         hAUTHMSG *phAuth);

/*
*   AuthMsgClose       -     CMS-nac
*
*       - phCrypt - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AuthMsgClose
                          (hAUTHMSG *phAuth);


/*
*   AuthMsgSet          -  
*
*       - hAuth     - 
*                         DName     -  
*                         crtSign   -   
*                         signSize  -
*                         crtExch   -  
*                         exchSize  -
*                         crlBody   - 
*                         crlSize   -
*
*      - authBuf   -  
*                         authSize  - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AuthMsgSet
                        (hAUTHMSG hAuth,
                        const char *DName,
                        const unsigned char *crtSign,
                        const unsigned long signSize,
                        const unsigned char *crtExch,
                        const unsigned long exchSize,
                        const unsigned char *crlBody,
                        const unsigned long crlSize,
                        unsigned char *authBuf,
                        unsigned long *authSize);

/*
*   AuthMsgDone         -   
*
*       - hAuth     - 
*                         authBuf   -  
*                         authSize  -
*
*      - DName     -  
*                         crtSign   -   
*                         signSize  -
*                         crtExch   -  
*                         exchSize  -
*                         crlBody   -   
*                         crlSize   -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AuthMsgDone
                        (hAUTHMSG hAuth,
                         const unsigned char *authBuf,
                         const unsigned long authSize,
                         char *DName,
                         unsigned char *crtSign,
                         unsigned long *signSize,
                         unsigned char *crtExch,
                         unsigned long *exchSize,
                         unsigned char **crlBody,
                         unsigned long *crlSize);

/*
*   AuthMsgVerify       -  
*
*       - hAuth     - 
*                         authBuf   -  
*                         authSize  -
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int AuthMsgVerify
                        (hAUTHMSG hAuth,
                         const unsigned char *authBuf,
                         const unsigned long authSize);


/*
*   ImitMsgOpen        -     CMS-mac
*
*       - hProv -   
*                         Flag  - 
*
*      - phCrypt - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ImitMsgOpen
                        (HCRYPTPROV hProv,
                         int Flags,
                         hCRYPTMSG *phCrypt);


/*
*   ImitMsgClose       -     CMS-mac
*
*       - phCrypt - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ImitMsgClose
                          (hCRYPTMSG *phCrypt);


//_WIN_DLL int CryptMsgTime
//                          (const hCRYPTMSG hCrypt,
//                           time_t *time, 
//                           unsigned short *millitm, 
//                           time_t *_time, 
//                           unsigned short *_millitm);


/*
*   ImitMessage        -  CMS-mac
*
*       - phCrypt        -   cms
*                         hCollection    -  ()   
*                         MYCert         -    
*                         crypthOID      - 
*                         hashOID        - 
*                         imitOID        - 
*                         Final
*                         dataOID
*                         dataToEncrypted
*                         dataSize
*                         dataDescriptor
*                         Flags         -  0 -    .
*
*      - encryptedBlob -  CMS-crypt
*                         sizeBlob      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ImitMessage
                         (const hCRYPTMSG hCrypt,
                          const hCERTCOLLECTION hCollection,
                          const hCERTCONTEXT MYCert,
                          const char *cryptOID,
                          const char *hashOID,
                          const char *imitOID,
                          const char *dataOID,
                          const bool Final,
                          const unsigned char *dataToEncrypted,
                          const unsigned long dataSize,
                          const char *dataDescriptor,
                          const unsigned long Flags,
                          unsigned char *encryptedBlob,
                          unsigned long *sizeBlob);



/*
*   DeimitMessage      -  CMS-mac
*
*       - phCrypt       -   cms
*                         MYCert        -  
*                         hStore        -  ()  
*                         Final
*                         encryptedBlob -  CMS-crypt
*                         sizeBlob      - 
*                         Flags         - 
*
*      - SenderName    -    
*                         timeToImited  -     
*                         dataDescriptor-   
*                         dataToSigned  -    
*                         dataSize      - 
*                         VerifyRes     -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DeimitMessage
                          (const hCRYPTMSG hCrypt,
                           const hCERTCOLLECTION hCollection,
                           const hCERTCONTEXT MYCert,
                           const bool Final,
                           const unsigned char *encryptedBlob,
                           const unsigned long sizeBlob,
                           const int Flags,
                           char *SenderName,
                           char *timeToImited,
                           char *dataDescriptor,
                           unsigned char *dataToDecrypted,
                           unsigned long *dataSize,
                           int *VerifyRes);


/*
*   HashMsgOpen         -     CMS-hash
*
*       - hProv -   
*                         Flag  - 
*
*      - phCrypt - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int HashMsgOpen
                        (HCRYPTPROV hProv,
                         int Flags,
                         hCRYPTMSG *phCrypt);



/*
*   HashMsgClose        -     CMS-hash
*
*       - phCrypt - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int HashMsgClose
                          (hCRYPTMSG *phCrypt);



/*
*   HashMessage         -  CMS-hash
*
*       - phCrypt       -   cms
*                         hashOID       -    
*                         dataOID       -  
*                         Final
*                         dataToHashed  -   
*                         dataSize      - 
*                         Flags         - 
*
*      - hashedBlob    - CMS-hash
*                         sizeBlob      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int HashMessage
                        (const hCRYPTMSG hCrypt,
                         const char *hashOID,
                         const char *dataOID,
                         const bool Final,
                         const unsigned char *dataToHashed,
                         const unsigned long dataSize,
                         const unsigned long Flags,
                         unsigned char *hashedBlob,
                         unsigned long *sizeBlob);



/*
*   VerifyHashMessage   -  CMS-sign
*
*       - phCrypt       -   cms
*                         hashedBlob    - CMS-hash
*                         sizeBlob      - 
*                         Final         -   
*
*      - dataToSigned  -    
*                         dataSize      - 
*                         dataOID       -   
*                         VerifyRes     -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int VerifyHashMessage
                              (const hCRYPTMSG hCrypt,
                               const unsigned char *hashedBlob,
                               const unsigned long sizeBlob,
                               const bool Final,
                               unsigned char *dataToHashed,
                               unsigned long *dataSize,
                               char *dataOID,
                               int *VerifyRes);


/*
*   CryptMsgOpen        -     CMS-crypt
*
*       - hProv -   
*                         Flag  - 
*
*      - phCrypt - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrptMsgOpen
                        (HCRYPTPROV hProv,
                         int Flags,
                         hCRYPTMSG *phCrypt);



/*
*   CryptMsgClose       -     CMS-crypt
*
*       - phCrypt - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CrptMsgClose
                          (hCRYPTMSG *phCrypt);



/*
*   CryptMessage        -  CMS-crypt
*
*       - phCrypt         -   cms
*                         hCollection     -  ()   
*                         MYCert          -    
*                         crypthOID       -   (szOID_TGR3410        "1.3.6.1.4.1.6801.1.2.2")
*                         dataOID         - ,    (NULL - default)
*                         Final           -   
*                         dataToEncrypted -  
*                         dataSize        - 
*                         dataDescriptor  -  
*                         Flags           -  0 -    
*
*      - encryptedBlob - CMS-crypt
*                         sizeBlob      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int CryptMessage
                        (const hCRYPTMSG hCrypt,
                         const hCERTCOLLECTION hCollection,
                         const hCERTCONTEXT MYCert,
                         const char *cryptOID,
                         const char *dataOID,
                         const bool Final,
                         unsigned char *dataToEncrypted,
                         unsigned long dataSize,
                         const char *dataDescriptor,
                         const unsigned long Flags,
                         unsigned char *encryptedBlob,
                         unsigned long *sizeBlob);



/*
*   DecryptMessage      -  CMS-crypt
*
*       - hCrypt          -   cms
*                         hCollection     -  ()   
*                         MYCert          -    
*                         Final           -   
*                         encryptedBlob   -  CMS-crypt
*                         sizeBlob        - 
*
*      - SenderName      -  
*                         timeToCrypted   -     
*                         dataDescriptor  -  
*                         dataToDecrypted -  
*                         dataSize        - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int DecryptMessage
                          (const hCRYPTMSG hCrypt,
                           const hCERTCOLLECTION hCollection,
                           const hCERTCONTEXT MYCert,
                           const bool Final,
                           const unsigned char *encryptedBlob,
                           const unsigned long sizeBlob,
                           char *SenderName,
                           char *timeToCrypted,
                           char *dataDescriptor,
                           unsigned char *dataToDecrypted,
                           unsigned long *dataSize);


/*
*   SignMsgOpen         -     CMS-sign
*
*       - hProv -   
*                         Flag  - 
*
*      - phCrypt - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SignMsgOpen
                        (HCRYPTPROV hProv,
                         int Flags,
                         hCRYPTMSG *phCrypt);

/*
*   SignMsgPKCS11       -    PKCS11
*
*       - phCrypt -   cms
*                         hProv   -   PKCS11
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SignMsgPKCS11(const hCRYPTMSG hCrypt,
                           const HCRYPTPROV hProv);


/*
*   SignMsgClose        -     CMS-sign
*
*       - phCrypt - 
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SignMsgClose
                          (hCRYPTMSG *phCrypt);


/*
*   SignMessageNoSign   -  CMS-sign   
*
*       - phCrypt       -   cms
*                         CACert        -    CA
*                         MYCert        -    
*                         dataToSigned  -   
*                         dataSize      - 
*                         Flags         -  0 -    
*
*      - signedBlob    - CMS-sign
*                         sizeBlob      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SignMessageNoSign
                              (const hCRYPTMSG hCrypt,
                               const hCERTCONTEXT CACert,
                               const hCERTCONTEXT MYCert,
                               const char *dataOID,
                               const unsigned char *dataToSigned,
                               const unsigned long dataSize,
                               const unsigned long Flags,
                               unsigned char *signedBlob,
                               unsigned long *sizeBlob);


/*
*   SignMessage         -  CMS-sign
*
*       - phCrypt       -   cms
*                         hStore        -  ()  
*                         MYCert        -    
*                         hashOID       -  
*                         signOID       -  
*                         dataOID       - ,    (NULL - default)
*                         Final         -   
*                         dataToSigned  -   
*                         dataSize      - 
*                         dataDescriptor-  
*                         Flags         -  0 -    
*
*      - signedBlob    - CMS-sign
*                         sizeBlob      - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SignMessage
                        (const hCRYPTMSG hCrypt,
                         const hCERTSTORE hStore,
                         const hCERTCONTEXT MYCert,
                         const char *hashOID,
                         const char *signOID,
                         const char *dataOID,
                         const bool Final,
                         const unsigned char *dataToSigned,
                         const unsigned long dataSize,
                         const char *dataDescriptor,
                         const unsigned long Flags,
                         unsigned char *signedBlob,
                         unsigned long *sizeBlob);

/*
*   VerifySignMessage   -   CMS-sign
*
*       - phCrypt       -   cms
*                         hCollection   -    
*                         signedBlob    - CMS-sign
*                         sizeBlob      - 
*                         Flags         -
*
*      - signerName    -    
*                         timeToSigned  -    
*                         dataDescriptor-   
*                         dataToSigned  -    
*                         dataSize      - 
*                         dataOID       -   ',   
*                         VerifyRes     -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int VerifySignMessage
                              (const hCRYPTMSG hCrypt,
                               const hCERTCOLLECTION hCollection,
                               const unsigned char *SignedBlob,
                               const unsigned long sizeBlob,
                               const int Flags,
                               char **SignerName,
                               char **timeToSigned,
                               char **dataDescriptor,
                               unsigned char *dataToSigned,
                               unsigned long *dataSize,
                               char **dataOID,
                               int *VerifyRes);


/*
*   MessageType         -  CMS    
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - type      -   (CMS_SIGN_DATA, CMS_AUTH_DATA, CMS_ENVP_DATA)
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageType
                        (const unsigned char *cmsData,
                         const unsigned long dataSize,
                         int  *type);



/*
*   MessageKeysCount    -  CMS      ()
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - count     - -  (CMS_SIGN_DATA)   (CMS_AUTH_DATA, CMS_ENVP_DATA)
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageKeysCount
                             (const unsigned char *cmsData,
                              const unsigned long dataSize,
                              int  *count);


/*
*   MessageInfo         -      CMS   ( )  
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - Time      -   
*                         haveCert  -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageInfo
                        (const unsigned char *cmsData,
                         const unsigned long dataSize,
                         bool *haveCert,
                         char *Time);



/*
*   MessageSignature    -  
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - Signature -  ( )
*                         size      -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageSignature
                            (const unsigned char *cmsData,
                             const unsigned long dataSize,
                             unsigned char *Signature,
                             unsigned long *size);


/*
*   MessageSignatureAlg -   
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - SignOID   -  
*                         HashOID   -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageSignatureAlg
                                (const unsigned char *cmsData,
                                 const unsigned long dataSize,
                                 char *SignOID,
                                 char *HashOID);

/*
*   MessageDigest       -  -
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - Digest    - - ( )
*                         digestSize-  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageDigest
                            (const unsigned char *cmsData,
                             const unsigned long dataSize,
                             unsigned char *Digest,
                             unsigned long *digestSize);


/*
*   MessageName         -    /  CMS 
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - senderCount - - 
*                         senderName  -   
*                         recipCount  - - 
*                         recipName   -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageName
                        (const unsigned char *cmsData,
                         const unsigned long dataSize,
                         int *senderCount,
                         char **senderName,
                         int *recipCount,
                         char **recipName);



/*
*   MessageCert         -       CMS 
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - certCount - - 
*                         certBody  -    ( )
*                         certSize  -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageCert
                        (const unsigned char *cmsData,
                         const unsigned long dataSize,
                         int *certCount,
                         unsigned char **certBody,
                         unsigned long *certSize);



/*
*   MessageSender       -       CMS 
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - keyCount    - - 
*                         serNum      -   /  
*                         serNumSize  -    / 
*                         issuerName  -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageSender
                        (const unsigned char *cmsData,
                         const unsigned long dataSize,
                         int *keyCount,
                         unsigned char **serNum,
                         unsigned long *serNumSize,
                         char **issuerName);


/*
*   MessageRecip        -       CMS 
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - keyCount    - - 
*                         serNum      -      
*                         serNumSize  -      
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageRecip
                        (const unsigned char *cmsData,
                         const unsigned long dataSize,
                         int *keyCount,
                         unsigned char **serNum,
                         unsigned long *serNumSize);

/*
*   MessageEncryptedKey  -       CMS 
*
*       - cmsData   - CMS 
*                         dataSize  - 
*
*      - crptAlgorithm - OID 
*                         keyCount    - - 
*                         crptKey     -      
*                         crptKeySize -      
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int MessageEncryptedKey
                               (const unsigned char *cmsData,
                                const unsigned long dataSize,
                                char *crptAlgorithm,
                                int *keyCount,
                                unsigned char **crptKey,
                                unsigned long *crptKeySize);

/*
*   BinToBase            -     Base64
*
*       - inBuf       -  
*                         inSize      - 
*
*      - ouBuf       -    Base64
*                         outSize     -  ( )
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int BinToBase
                      (unsigned char *inBuf, 
                       long inSize, 
                       unsigned char *ouBuf,
                       long *outSize);


/*
*   BaseToBin            -   Base64  
*
*       - inBuf       -    Base64
*                         inSize      - 
*
*      - ouBuf       -  
*                         outSize     -  () 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int BaseToBin
                    (unsigned char *inBuf, 
                     long inSize, 
                     unsigned char *ouBuf,
                     long *outSize);



/*
*   BinToPEM            -     PEM
*
*       - inBuf       -  
*                         inSize      - 
*                         type        -  
*                                       #define PEM_X509_OLD      0
*                                       #define PEM_X509          1
*                                       #define PEM_X509_PAIR     2
*                                       #define PEM_X509_TRUSTED  3
*                                       #define PEM_X509_REQ_OLD  4
*                                       #define PEM_X509_REQ      5
*                                       #define PEM_X509_CRL      6
*                                       #define PEM_EVP_PKEY      7
*                                       #define PEM_PUBLIC        8
*                                       #define PEM_RSA           9 
*                                       #define PEM_RSA_PUBLIC   10
*                                       #define PEM_DSA          11
*                                       #define PEM_DSA_PUBLIC   12
*                                       #define PEM_PKCS7        13
*                                       #define PEM_PKCS8        14
*                                       #define PEM_PKCS8INF     15
*                                       #define PEM_DHPARAMS     16
*                                       #define PEM_SSL_SESSION  17
*                                       #define PEM_DSAPARAMS    18
*                                       #define PEM_ECDSA_PUBLIC 19
*                                       #define PEM_ECPARAMETERS 20
*                                       #define PEM_ECPRIVATEKEY 21
*
*      - ouBuf       -    Base64
*                         outSize     -  ( )
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int BinToPEM(unsigned char *inBuf, 
                      long inSize, 
                      int type,
                      unsigned char *ouBuf,
                      long *outSize);


/*
*   PEMToBin            -   PEM  
*
*       - inBuf       -    Base64
*                         inSize      - 
*                         index       -   ( 0)
*
*      - type        -  
*                         ouBuf       -  
*                         outSize     -  () 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int PEMToBin(unsigned char *inBuf, 
                      long inSize, 
                      int index,
                      int *type,
                      unsigned char *ouBuf,
                      long *outSize);


/*
*   BinToStr          -    (CAPICOM)  
*
*       - inBuf       -  
*                         inSize      - 
*
*      - ouBuf       -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int BinToStr
                    (unsigned char *inBuf, 
                     long inSize, 
                     char *ouBuf);

/*
*   StrToBin          -      (CAPICOM) 
*
*       - inBuf       - - 
*
*      - ouBuf       -  
*                         outSize     -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int StrToBin
                    (char *inBuf, 
                     unsigned char *ouBuf,
                     long *outSize);


/*
*   BinToStr          -    (CAPICOM)  
*
*       - inBuf       -  
*                         inSize      - 
*                         cpage       - #define CPAGE_ASCII    0
*                                       #define CPAGE_CP1251KZ 1 // default
*                                       #define CPAGE_KOI8R    2
*                                       #define CPAGE_CP1251RU 3
*                                       #define CPAGE_KZ1048   4
*
*      - ouBuf       -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int BinToStrEx
                    (unsigned char *inBuf, 
                     long inSize, 
                     int cpage,
                     char *ouBuf);

/*
*   StrToBin          -      (CAPICOM) 
*
*       - inBuf       - - 
*                         cpage       - #define CPAGE_ASCII    0
*                                       #define CPAGE_CP1251KZ 1 // default
*                                       #define CPAGE_KOI8R    2
*                                       #define CPAGE_CP1251RU 3
*                                       #define CPAGE_KZ1048   4
*
*      - ouBuf       -  
*                         outSize     -   
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int StrToBinEx
                    (char *inBuf, 
                     int cpage,
                     unsigned char *ouBuf,
                     long *outSize);

/*
*   BinToHex            -     
*
*       - inBuf       - 
*                         inSize      - 
*
*      - ouBuf       -     
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int BinToHex
                      (unsigned char *inBuf, 
                       unsigned long inSize, 
                       unsigned char *ouBuf);


/*
*   HexToBin            -     
*
*       - inBuf       - 
*                         inSize      - 
*
*      - ouBuf       -     
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int HexToBin
                    (unsigned char *inBuf, 
                     unsigned long inSize, 
                     unsigned char *ouBuf);


/*
*   GetMessageCertificate -       CMS
*
*       - hStore   -  ()  
*                         CMSBlob  - CMS
*                         sizeBlob -  CMS
*
*      - hCollection -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetMessageCertificate
                                  (const hCERTSTORE hStore,
                                   const unsigned char *CMSBlob,
                                   const unsigned long sizeBlob,
                                   hCERTCOLLECTION *hCollection);

/*
*   FreeCertificateCollection -     
*
*       - hCollection -    
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int FreeCertificateCollection
                                      (hCERTCOLLECTION *phCollection);




/*
*   GetCertificateCollectionCount -  -   
*
*       - hCollection -    
*
*      - .
*
*              - -   
*/
_WIN_DLL int GetCertificateCollectionCount
                                          (const hCERTCOLLECTION hCollection);


/*
*   VerifyCertCollection -   
*
*       - hCollection -    
*                         hCA         -     
*                         hRoot       -     
*                         hTrust      - 
*                         useOCSP     -   OCSP
*                         timeVerify  -  
*                         Flags       - 
*
*      - result -  .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int VerifyCertificateCollection
                                (const hCERTCOLLECTION hCollection,
                                 const hCERTSTORE hCA,
                                 const hCERTSTORE hRoot,
                                 const hCERTSTORE hTrust,
                                 const bool useOCSP,
                                 const char *timeVerify,
                                 const int Flags,
                                 int *result);


/*
*   GetCertificateCollection -     
*
*       - hStore    -  ()  
*                         hMY       -  ()  
*                         keyOID    -    
*                         nameCount - -    DName
*                         DName     -  
*
*      - hCollection -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertificateCollection
                                      (const hCERTSTORE hStore,
                                       const hCERTSTORE hMY,
                                       const char *keyOID,
                                       const int nameCount,
                                       char **DName,
                                       hCERTCOLLECTION *hCollection);


/*
*   GetCertificateCollectionEx -     
*
*       - hStore    -  ()  
*                         certCount - - 
*                         certBuf   -  
*                         certSize  -  
*
*      - hCollection -    
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertificateCollectionEx
                                      (const hCERTSTORE hStore,
                                       const int certCount,
                                       unsigned char **certBuf,
                                       unsigned long *certSize,
                                       hCERTCOLLECTION *hCollection);


/*
*   OpenCertificateChain -      
*
*       - hStore  -  ()  
*                         hCA
*                         hRoot
*                         hTrust
*                         useOCSP
*
*
*      - phChain  -   .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int OpenCertificateChain
                                (const hCERTSTORE hStore,
                                 const hCERTSTORE hCA,
                                 const hCERTSTORE hRoot,
                                 const hCERTSTORE hTrust,
                                 const bool useOCSP,
                                 hCERTCHAINCONTEXT *phChain);


/*
*   FreeCertificateChain -      
*
*       - phChain  -   
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int FreeCertificateChain
                                    (hCERTCHAINCONTEXT *phChain);


/*
*   VerifyCertificateChain -   /
*
*       - hChain  -   
*                         timeVerify
*                         Flags
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int VerifyCertificateChain
                                    (const hCERTCHAINCONTEXT hChain,
                                     const char *timeVerify,
                                     const int Flags);


/*
*   VerifyFastCertificate -   /
*
*       - hChain  -   
*                         hContext     
*                         timeVerify
*                         Flags
*
*      - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int VerifyFastCertificate
                                  (const hCERTCHAINCONTEXT hChain,
                                   const hCERTCONTEXT hContext,
                                   const char *timeVerify,
                                   const int Flags);


/*
*   SetCertificateChain -   /  
*
*       - hChain   -   
*                         hContext -    
*                         Flag     -  0 -        
*
*      -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetCertificateChain
                                (const hCERTCHAINCONTEXT hChain,
                                 const hCERTCONTEXT hContext,
                                 const int Flag);


/*
*   SetCertificateChainEx -   /  
*
*       - hChain  -   
*                         hCert   -    
*                         hCA     -     
*                         hCrl    -    
*                         Flag    - 
*
*      -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SetCertificateChainEx
                                (const hCERTCHAINCONTEXT hChain,
                                 const hCERTCONTEXT hCert,
                                 const hCERTCONTEXT hCA,
                                 const hCERTCONTEXT hCrl,
                                 const int Flag);

/*
*   GetCertificateChain -   /
*
*       - hChain  -   
*                         phContext
*
*      -
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int GetCertificateChain
                                (const hCERTCHAINCONTEXT hChain,
                                 CERT_CRL_CHAIN *phContext);

/*
*   RequestCRLoffline   -  LDAP   CRL
*
*       - type  -  0 - ATTRIBUTE_DELTA_CRL, 1 - ATTRIBUTE_DRAFT_CRL, 
*                                  ATTRIBUTE_CRL
*                         id    - 
*                         DName -
*
*      - reqCRL  -  .
*                                      .
*                                     NULL,    .
*                         reqSize -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int RequestCRLoffline
                              (const int type,
                               const int id,
                               const char *DName,
                               unsigned char *reqCRL,
                               unsigned long *reqSize);

/*
*   RequestCAoffline   -  LDAP    
*
*       - id  - 
*
*      - reqCAcert  -  .
*                                         .
*                                        NULL,    .
*                         reqSize    -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int RequestCAoffline
                              (const int id,
                               unsigned char *reqCAcert,
                               unsigned long *reqSize);



/*
*   RequestCertOffline   -  LDAP    
*
*       - DName      -     DN
*                         id
*                         sernum
*                         numsize
*
*      - reqCert    -  .
*                                         .
*                                        NULL,    .
*                         reqSize    -  
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int RequestCertOffline
                              (const char *DName,
                               const int   id,
                               const unsigned char *sernum, 
                               const unsigned long numsize, 
                               unsigned char *reqCert,
                               unsigned long *reqSize);


/*
*   RequestOfflineInfo   -    LDAP 
*
*       - reqBuf    -  
*                         reqSize   - 
*
*      - DName      -     DN
*                         attrList   -  
*                         id
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int RequestOfflineInfo
                              (const unsigned char *reqBuf,
                               const unsigned long reqSize,
                               char *DName,
                               char *attrList,
                               int  *id);


/*
*   RequestOfflineFilter   -    LDAP 
*
*       - reqBuf    -  
*                         reqSize   - 
*
*      - filter     - 
*                         filterSize - 
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int RequestOfflineFilter
                              (const unsigned char *reqBuf,
                               const unsigned long reqSize,
                               unsigned char *filter, 
                               unsigned long *filterSize);


/*
*   ResponceOnlineGet   -  LDAP 
*
*       - hStore  -  ()  
*                         DName   -     DN.
*                         Filter  - 
*                         attr    -  : ATTRIBUTE_CA_CERTIFICATE
*                                             ATTRIBUTE_CRL
*                                             ATTRIBUTE_USER_CERTIFICATE
*                                             ATTRIBUTE_REV_CERTIFICATE
*
*      - respBody - LDAP .
*                                       .
*                                      NULL,    .
*                         bodySize - .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ResponceOnlineGet
                              (hCERTSTORE hStore,
                               const char *DName,
                               unsigned char *Filter,
                               const char *attr,
                               unsigned char *respBody,
                               unsigned long *bodySize);


/*
*   ResponceOfflineInfo -    LDAP 
*
*       - respBuf    -  
*                         respSize   - 
*
*      - DName      -     DN [256]
*                                         .
*                         attrList   -   [256]
*                                         .
*                         id
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ResponceOfflineInfo
                                (const unsigned char *respBuf,
                                 const unsigned long respSize,
                                 char *DName,
                                 char *attrList,
                                 int  *id);

/*
*   ResponceOfflineGet -    LDAP 
*
*       - respBuf    -  
*                         respSize   - 
*                         attr    -  : ATTRIBUTE_CA_CERTIFICATE
*                                             ATTRIBUTE_CRL
*                                             ATTRIBUTE_USER_CERTIFICATE
*                                             ATTRIBUTE_REV_CERTIFICATE
*
*      - count     -   
*                         respBody  -  .
*                                        .
*                                       NULL,    .
*                         bodySize -    .
*                                        .
*                                       NULL,    .
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int ResponceOfflineGet
                              (const unsigned char *respBuf,
                               const unsigned long respSize,
                               const char *attr,
                               int  *count,
                               unsigned char **respBody,
                               unsigned long *bodySize);


/*
*   SendPKIMessage      -  PKI    TCP
*
*       - sendBlob  -   
*                         sendSize  - 
*                         ipCA      - IP  
*                         portCA    -  
*                         timeOut   -  
*                         Flag      - 0-(SendMess+RecvMess), 1-(PutBlock+GetBlock)
*
*      - respBlob  -   
*                                        
*                         respSize -     
*
*              - 0    ,   myerror.h
*/
_WIN_DLL int SendPKIMessage
                        (const unsigned char *sendBlob,
                         const unsigned long sendSize,
                         char *ipCA,
                         char *portCA,
                         int timeOut,
                         int Flag,
                         unsigned char *respBlob,
                         unsigned long *respSize);

#endif
